/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lesu;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.RebornCoreConfig;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.blocks.storage.BlockLapotronicSU;
import techreborn.init.ModBlocks;
import techreborn.tiles.lesu.LesuNetwork;
import techreborn.tiles.lesu.TileLSUStorage;
import techreborn.tiles.storage.TileEnergyStorage;

@RebornRegistry(modID="techreborn")
public class TileLapotronicSU
extends TileEnergyStorage
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="lesu", key="LesuMaxOutput", comment="LESU Base Output (Value in EU)")
    public static int baseOutput = 16;
    @ConfigRegistry(config="machines", category="lesu", key="LesuMaxEnergyPerBlock", comment="LESU Max Energy Per Block (Value in EU)")
    public static int storagePerBlock = 1000000;
    @ConfigRegistry(config="machines", category="lesu", key="LesuExtraIO", comment="LESU Extra I/O Multiplier")
    public static int extraIOPerBlock = 8;
    public int connectedBlocks = 0;
    private ArrayList<LesuNetwork> countedNetworks = new ArrayList();

    public TileLapotronicSU() {
        super("LESU", 2, ModBlocks.LAPOTRONIC_SU, EnumPowerTier.INSANE, 8192, baseOutput, 1000000);
        this.checkOverfill = false;
    }

    @Override
    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        this.countedNetworks.clear();
        this.connectedBlocks = 0;
        for (EnumFacing dir : EnumFacing.values()) {
            LesuNetwork network;
            BlockPos adjucentBlockPos = new BlockPos(this.pos.getX() + dir.getFrontOffsetX(), this.pos.getY() + dir.getFrontOffsetY(), this.pos.getZ() + dir.getFrontOffsetZ());
            TileEntity adjucentTile = this.world.getTileEntity(adjucentBlockPos);
            if (adjucentTile == null || !(adjucentTile instanceof TileLSUStorage) || ((TileLSUStorage)adjucentTile).network == null || this.countedNetworks.contains(network = ((TileLSUStorage)adjucentTile).network) || network.master != null && network.master != this) continue;
            this.connectedBlocks += network.storages.size();
            this.countedNetworks.add(network);
            network.master = this;
            break;
        }
        this.setMaxStorage();
        this.maxOutput = this.connectedBlocks * extraIOPerBlock + baseOutput;
    }

    @Override
    public EnumFacing getFacingEnum() {
        Block block = this.world.getBlockState(this.pos).getBlock();
        if (block instanceof BlockLapotronicSU) {
            return ((BlockLapotronicSU)block).getFacing(this.world.getBlockState(this.pos));
        }
        return null;
    }

    public int getOutputRate() {
        return this.maxOutput;
    }

    public void setOutputRate(int output) {
        this.maxOutput = output;
    }

    public int getConnectedBlocksNum() {
        return this.connectedBlocks;
    }

    public void setConnectedBlocksNum(int value) {
        this.connectedBlocks = value;
        if (this.world.isRemote) {
            this.setMaxStorage();
        }
    }

    public void setMaxStorage() {
        this.maxStorage = (this.connectedBlocks + 1) * storagePerBlock;
        if (this.maxStorage < 0 || this.maxStorage > Integer.MAX_VALUE / RebornCoreConfig.euPerFU) {
            this.maxStorage = Integer.MAX_VALUE / RebornCoreConfig.euPerFU;
        }
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("lesu").player(player.inventory).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().tile((IInventory)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().syncIntegerValue(this::getOutputRate, this::setOutputRate).syncIntegerValue(this::getConnectedBlocksNum, this::setConnectedBlocksNum).addInventory().create((TileLegacyMachineBase)this);
    }
}

