/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lighting;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.blocks.lighting.BlockLamp;

public class TileLamp
extends TilePowerAcceptor
implements IToolDrop {
    private static int capacity = 33;

    public void update() {
        super.update();
        if (this.world == null || this.world.isRemote) {
            return;
        }
        IBlockState state = this.world.getBlockState(this.pos);
        Block b = state.getBlock();
        if (b instanceof BlockLamp) {
            double cost = this.getEuPerTick(((BlockLamp)b).getCost());
            if (this.getEnergy() > cost) {
                this.useEnergy(this.getEuPerTick(cost));
                if (!BlockLamp.isActive(state)) {
                    BlockLamp.setActive(true, this.world, this.pos);
                }
            } else if (BlockLamp.isActive(state)) {
                BlockLamp.setActive(false, this.world, this.pos);
            }
        }
    }

    public double getBaseMaxPower() {
        return capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        EnumFacing me = BlockLamp.getFacing(this.world.getBlockState(this.pos)).getOpposite();
        return direction == me;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 32.0;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.world.getBlockState(this.pos).getBlock());
    }
}

