/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;

public class MultiblockChecker {
    public static final BlockPos ZERO_OFFSET = BlockPos.ORIGIN;
    public static final String STANDARD_CASING = "standard";
    public static final String REINFORCED_CASING = "reinforced";
    public static final String ADVANCED_CASING = "advanced";
    public static final String CASING_ANY = "any";
    private final World world;
    private final BlockPos downCenter;

    public MultiblockChecker(World world, BlockPos downCenter) {
        this.world = world;
        this.downCenter = downCenter;
    }

    public boolean checkCasing(int offX, int offY, int offZ, String type) {
        IBlockState block = this.getBlock(offX, offY, offZ);
        if (block.getBlock() == ModBlocks.MACHINE_CASINGS) {
            if (type == CASING_ANY) {
                return true;
            }
            if (((String)((Object)block.getValue((IProperty)BlockMachineCasing.TYPE))).equals(type)) {
                return true;
            }
        }
        return false;
    }

    public boolean checkAir(int offX, int offY, int offZ) {
        BlockPos pos = this.downCenter.add(offX, offY, offZ);
        return this.world.isAirBlock(pos);
    }

    public IBlockState getBlock(int offX, int offY, int offZ) {
        BlockPos pos = this.downCenter.add(offX, offY, offZ);
        return this.world.getBlockState(pos);
    }

    public boolean checkRectY(int sizeX, int sizeZ, String casingType, BlockPos offset) {
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int z = -sizeZ; z <= sizeZ; ++z) {
                if (this.checkCasing(x + offset.getX(), offset.getY(), z + offset.getZ(), casingType)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkRectZ(int sizeX, int sizeY, String casingType, BlockPos offset) {
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                if (this.checkCasing(x + offset.getX(), y + offset.getY(), offset.getZ(), casingType)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkRectX(int sizeZ, int sizeY, String casingType, BlockPos offset) {
        for (int z = -sizeZ; z <= sizeZ; ++z) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                if (this.checkCasing(offset.getX(), y + offset.getY(), z + offset.getZ(), casingType)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkRingY(int sizeX, int sizeZ, String casingType, BlockPos offset) {
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int z = -sizeZ; z <= sizeZ; ++z) {
                if (x != sizeX && x != -sizeX && z != sizeZ && z != -sizeZ || this.checkCasing(x + offset.getX(), offset.getY(), z + offset.getZ(), casingType)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkRingYHollow(int sizeX, int sizeZ, String casingType, BlockPos offset) {
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int z = -sizeZ; z <= sizeZ; ++z) {
                if (!(x == sizeX || x == -sizeX || z == sizeZ || z == -sizeZ ? !this.checkCasing(x + offset.getX(), offset.getY(), z + offset.getZ(), casingType) : !this.checkAir(x + offset.getX(), offset.getY(), z + offset.getZ()))) continue;
                return false;
            }
        }
        return true;
    }
}

