/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileDistillationTower
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="distillation_tower", key="DistillationTowerMaxInput", comment="Distillation Tower Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="distillation_tower", key="DistillationTowerMaxEnergy", comment="Distillation Tower Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public MultiblockChecker multiblockChecker;

    public TileDistillationTower() {
        super("DistillationTower", maxInput, maxEnergy, ModBlocks.DISTILLATION_TOWER, 6);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.inventory = new Inventory(7, "TileDistillationTower", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.DISTILLATION_TOWER_RECIPE, (TileEntity)this, 2, 4, this.inventory, inputs, outputs);
    }

    public boolean getMutliBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean layer0 = this.multiblockChecker.checkRectY(1, 1, "standard", MultiblockChecker.ZERO_OFFSET);
        boolean layer1 = this.multiblockChecker.checkRingY(1, 1, "advanced", new BlockPos(0, 1, 0));
        boolean layer2 = this.multiblockChecker.checkRingY(1, 1, "standard", new BlockPos(0, 2, 0));
        boolean layer3 = this.multiblockChecker.checkRectY(1, 1, "advanced", new BlockPos(0, 3, 0));
        Material centerBlock1 = this.multiblockChecker.getBlock(0, 1, 0).getMaterial();
        Material centerBlock2 = this.multiblockChecker.getBlock(0, 2, 0).getMaterial();
        boolean center1 = centerBlock1 == Material.AIR;
        boolean center2 = centerBlock2 == Material.AIR;
        return layer0 && layer1 && layer2 && layer3 && center1 && center2;
    }

    @Override
    public void update() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.pos.offset(this.getFacing().getOpposite(), 2);
            this.multiblockChecker = new MultiblockChecker(this.world, downCenter);
        }
        if (!this.world.isRemote && this.getMutliBlock()) {
            super.update();
        }
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("distillationtower").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 35, 27).slot(1, 35, 47).outputSlot(2, 79, 37).outputSlot(3, 99, 37).outputSlot(4, 119, 37).outputSlot(5, 139, 37).energySlot(6, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }
}

