/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.fluidreplicator.FluidReplicatorRecipeCrafter;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileFluidReplicator
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="fluidreplicator", key="FluidReplicatorMaxInput", comment="Fluid Replicator Max Input (Value in EU)")
    public static int maxInput = 256;
    @ConfigRegistry(config="machines", category="fluidreplicator", key="FluidReplicatorMaxEnergy", comment="Fluid Replicator Max Energy (Value in EU)")
    public static int maxEnergy = 400000;
    public MultiblockChecker multiblockChecker;
    public static final int TANK_CAPACITY = 16000;
    public Tank tank;
    int ticksSinceLastChange;

    public TileFluidReplicator() {
        super("FluidReplicator", maxInput, maxEnergy, ModBlocks.FLUID_REPLICATOR, 3);
        int[] inputs = new int[]{0};
        this.inventory = new Inventory(4, "TileFluidReplicator", 64, (TileEntity)this);
        this.crafter = new FluidReplicatorRecipeCrafter((TileEntity)this, this.inventory, inputs, null);
        this.tank = new Tank("TileFluidReplicator", 16000, (TileLegacyMachineBase)this);
    }

    public boolean getMultiBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean ring = this.multiblockChecker.checkRingY(1, 1, "reinforced", MultiblockChecker.ZERO_OFFSET);
        return ring;
    }

    @Override
    public void update() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.pos.offset(this.getFacing().getOpposite(), 2);
            this.multiblockChecker = new MultiblockChecker(this.world, downCenter);
        }
        ++this.ticksSinceLastChange;
        if (!this.world.isRemote && this.ticksSinceLastChange >= 10) {
            if (!this.inventory.getStackInSlot(1).isEmpty()) {
                FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)1, (int)2, (Fluid)this.tank.getFluidType());
            }
            this.ticksSinceLastChange = 0;
        }
        if (this.getMultiBlock()) {
            super.update();
        }
        this.tank.compareAndUpdate();
    }

    @Override
    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return itemStack.isItemEqual(new ItemStack(ModItems.UU_MATTER));
        }
        return super.isItemValidForSlot(slotIndex, itemStack);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("fluidreplicator").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(1, 124, 35).filterSlot(0, 55, 45, stack -> stack.getItem() == ModItems.UU_MATTER).outputSlot(2, 124, 55).energySlot(3, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

