/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.multiblocks.MultiBlockCasing;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.TileMachineCasing;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileIndustrialBlastFurnace
extends TileGenericMachine
implements IContainerProvider,
ITileRecipeHandler<BlastFurnaceRecipe> {
    @ConfigRegistry(config="machines", category="industrial_furnace", key="IndustrialFurnaceMaxInput", comment="Industrial Blast Furnace Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="industrial_furnace", key="IndustrialFurnaceMaxEnergy", comment="Industrial Blast Furnace Max Energy (Value in EU)")
    public static int maxEnergy = 40000;
    public MultiblockChecker multiblockChecker;
    private int cachedHeat;

    public TileIndustrialBlastFurnace() {
        super("IndustrialBlastFurnace", maxInput, maxEnergy, ModBlocks.INDUSTRIAL_BLAST_FURNACE, 4);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.inventory = new Inventory(5, "TileIndustrialBlastFurnace", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.BLAST_FURNACE_RECIPE, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public int getHeat() {
        if (!this.getMutliBlock()) {
            return 0;
        }
        BlockPos location = this.pos.offset(this.getFacing().getOpposite(), 2);
        TileEntity tileEntity = this.world.getTileEntity(location);
        if (tileEntity instanceof TileMachineCasing && ((TileMachineCasing)tileEntity).isConnected() && ((TileMachineCasing)tileEntity).getMultiblockController().isAssembled()) {
            MultiBlockCasing casing = ((TileMachineCasing)tileEntity).getMultiblockController();
            int heat = 0;
            if (this.world.getBlockState(new BlockPos(location.getX(), location.getY() - 1, location.getZ())).getBlock() == tileEntity.getBlockType()) {
                return 0;
            }
            for (IMultiblockPart part : casing.connectedParts) {
                BlockMachineCasing casing1 = (BlockMachineCasing)this.world.getBlockState(part.getPos()).getBlock();
                heat += casing1.getHeatFromState(this.world.getBlockState(part.getPos()));
            }
            if (this.world.getBlockState(location.offset(EnumFacing.UP, 1)).getBlock().getUnlocalizedName().equals("tile.lava") && this.world.getBlockState(location.offset(EnumFacing.UP, 2)).getBlock().getUnlocalizedName().equals("tile.lava")) {
                heat += 500;
            }
            return heat;
        }
        return 0;
    }

    public boolean getMutliBlock() {
        boolean layer0 = this.multiblockChecker.checkRectY(1, 1, "any", MultiblockChecker.ZERO_OFFSET);
        boolean layer1 = this.multiblockChecker.checkRingY(1, 1, "any", new BlockPos(0, 1, 0));
        boolean layer2 = this.multiblockChecker.checkRingY(1, 1, "any", new BlockPos(0, 2, 0));
        boolean layer3 = this.multiblockChecker.checkRectY(1, 1, "any", new BlockPos(0, 3, 0));
        Material centerBlock1 = this.multiblockChecker.getBlock(0, 1, 0).getMaterial();
        Material centerBlock2 = this.multiblockChecker.getBlock(0, 2, 0).getMaterial();
        boolean center1 = centerBlock1 == Material.AIR || centerBlock1 == Material.LAVA;
        boolean center2 = centerBlock2 == Material.AIR || centerBlock2 == Material.LAVA;
        return layer0 && layer1 && layer2 && layer3 && center1 && center2;
    }

    public void setHeat(int heat) {
        this.cachedHeat = heat;
    }

    public int getCachedHeat() {
        return this.cachedHeat;
    }

    @Override
    public void update() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.pos.offset(this.getFacing().getOpposite(), 2);
            this.multiblockChecker = new MultiblockChecker(this.world, downCenter);
        }
        if (!this.world.isRemote && this.getMutliBlock()) {
            super.update();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.pos.getX(), this.pos.getY(), this.pos.getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("blastfurnace").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 50, 27).slot(1, 50, 47).outputSlot(2, 93, 37).outputSlot(3, 113, 37).energySlot(4, 8, 72).syncEnergyValue().syncCrafterValue().syncIntegerValue(this::getHeat, this::setHeat).addInventory().create((TileLegacyMachineBase)this);
    }

    @Override
    public boolean canCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        if (tile instanceof TileIndustrialBlastFurnace) {
            TileIndustrialBlastFurnace blastFurnace = (TileIndustrialBlastFurnace)tile;
            return blastFurnace.getHeat() >= recipe.neededHeat;
        }
        return false;
    }

    @Override
    public boolean onCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        return true;
    }
}

