/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileIndustrialGrinder
extends TileGenericMachine
implements IContainerProvider,
ITileRecipeHandler<IndustrialGrinderRecipe> {
    @ConfigRegistry(config="machines", category="industrial_grinder", key="IndustrialGrinderMaxInput", comment="Industrial Grinder Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="industrial_grinder", key="IndustrialGrinderMaxEnergy", comment="Industrial Grinder Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public static final int TANK_CAPACITY = 16000;
    public Tank tank;
    public MultiblockChecker multiblockChecker;
    int ticksSinceLastChange;

    public TileIndustrialGrinder() {
        super("IndustrialGrinder", maxInput, maxEnergy, ModBlocks.INDUSTRIAL_GRINDER, 7);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.inventory = new Inventory(8, "TileIndustrialGrinder", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.INDUSTRIAL_GRINDER_RECIPE, (TileEntity)this, 1, 4, this.inventory, inputs, outputs);
        this.tank = new Tank("TileIndustrialGrinder", 16000, (TileLegacyMachineBase)this);
        this.ticksSinceLastChange = 0;
    }

    public boolean getMultiBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean down = this.multiblockChecker.checkRectY(1, 1, "standard", MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, "standard", new BlockPos(0, 2, 0));
        boolean blade = this.multiblockChecker.checkRingY(1, 1, "reinforced", new BlockPos(0, 1, 0));
        IBlockState centerBlock = this.multiblockChecker.getBlock(0, 1, 0);
        boolean center = (centerBlock.getBlock() instanceof BlockLiquid || centerBlock.getBlock() instanceof IFluidBlock) && centerBlock.getMaterial() == Material.WATER;
        return down && center && blade && up;
    }

    @Override
    public void update() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.pos.offset(this.getFacing().getOpposite(), 2).down();
            this.multiblockChecker = new MultiblockChecker(this.world, downCenter);
        }
        ++this.ticksSinceLastChange;
        if (!this.world.isRemote && this.ticksSinceLastChange >= 10) {
            if (!this.inventory.getStackInSlot(1).isEmpty()) {
                FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)1, (int)6);
                FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)1, (int)6, (Fluid)this.tank.getFluidType());
            }
            this.ticksSinceLastChange = 0;
        }
        if (!this.world.isRemote && this.getMultiBlock()) {
            super.update();
        }
        this.tank.compareAndUpdate();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 1) {
            return itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return super.isItemValidForSlot(slotIndex, itemStack);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("industrialgrinder").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(1, 34, 35).slot(0, 84, 43).outputSlot(2, 126, 18).outputSlot(3, 126, 36).outputSlot(4, 126, 54).outputSlot(5, 126, 72).outputSlot(6, 34, 55).energySlot(7, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }

    @Override
    public boolean canCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        if (!this.getMultiBlock()) {
            return false;
        }
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        return tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount;
    }

    @Override
    public boolean onCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        if (tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount) {
            if (tankFluid.amount == recipeFluid.amount) {
                this.tank.setFluid(null);
            } else {
                tankFluid.amount -= recipeFluid.amount;
            }
            this.syncWithAll();
            return true;
        }
        return false;
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

