/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileVacuumFreezer
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="vacuumfreezer", key="VacuumFreezerInput", comment="Vacuum Freezer Max Input (Value in EU)")
    public static int maxInput = 64;
    @ConfigRegistry(config="machines", category="vacuumfreezer", key="VacuumFreezerMaxEnergy", comment="Vacuum Freezer Max Energy (Value in EU)")
    public static int maxEnergy = 64000;
    public MultiblockChecker multiblockChecker;

    public TileVacuumFreezer() {
        super("VacuumFreezer", maxInput, maxEnergy, ModBlocks.VACUUM_FREEZER, 2);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.inventory = new Inventory(3, "TileVacuumFreezer", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.VACUUM_FREEZER_RECIPE, (TileEntity)this, 2, 1, this.inventory, inputs, outputs);
    }

    public boolean getMultiBlock() {
        return this.multiblockChecker.checkRectY(1, 1, "reinforced", MultiblockChecker.ZERO_OFFSET);
    }

    @Override
    public void update() {
        if (!this.world.isRemote && this.getMultiBlock()) {
            super.update();
        }
    }

    public void validate() {
        super.validate();
        this.multiblockChecker = new MultiblockChecker(this.world, this.pos.down());
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("vacuumfreezer").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }
}

