/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.storage;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.blocks.storage.BlockEnergyStorage;

public class TileEnergyStorage
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider {
    public Inventory inventory;
    public String name;
    public Block wrenchDrop;
    public EnumPowerTier tier;
    public int maxInput;
    public int maxOutput;
    public int maxStorage;

    public TileEnergyStorage(String name, int invSize, Block wrenchDrop, EnumPowerTier tier, int maxInput, int maxOuput, int maxStorage) {
        this.inventory = new Inventory(invSize, "Tile" + name, 64, (TileEntity)this);
        this.wrenchDrop = wrenchDrop;
        this.tier = tier;
        this.name = name;
        this.maxInput = maxInput;
        this.maxOutput = maxOuput;
        this.maxStorage = maxStorage;
    }

    public void update() {
        ItemStack stack;
        super.update();
        if (!this.inventory.getStackInSlot(0).isEmpty() && ExternalPowerSystems.isPoweredItem((ItemStack)(stack = this.inventory.getStackInSlot(0)))) {
            ExternalPowerSystems.chargeItem((TilePowerAcceptor)this, (ItemStack)stack);
        }
        if (!this.inventory.getStackInSlot(1).isEmpty()) {
            this.charge(1);
        }
    }

    public double getBaseMaxPower() {
        return this.maxStorage;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return this.getFacing() != direction;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return this.getFacing() == direction;
    }

    public double getBaseMaxOutput() {
        return this.maxOutput;
    }

    public double getBaseMaxInput() {
        return this.maxInput;
    }

    public EnumPowerTier getBaseTier() {
        return this.tier;
    }

    public void setFacing(EnumFacing enumFacing) {
        this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)BlockEnergyStorage.FACING, (Comparable)enumFacing));
    }

    public EnumFacing getFacingEnum() {
        Block block = this.world.getBlockState(this.pos).getBlock();
        if (block instanceof BlockEnergyStorage) {
            return ((BlockEnergyStorage)block).getFacing(this.world.getBlockState(this.pos));
        }
        return null;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.wrenchDrop);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

