/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier0;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileIronFurnace
extends TileLegacyMachineBase
implements IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, (TileEntity)this);
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 160;
    int input1 = 0;
    int output = 1;
    int fuelslot = 2;
    boolean active = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel > 0) {
            --this.fuel;
            this.updateState();
        }
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = (int)((double)TileEntityFurnace.getItemBurnTime((ItemStack)this.getStackInSlot(this.fuelslot)) * 1.25);
            if (this.fuel > 0) {
                ItemStack fuelStack = this.getStackInSlot(this.fuelslot);
                if (fuelStack.getItem().hasContainerItem(fuelStack)) {
                    this.setInventorySlotContents(this.fuelslot, new ItemStack(fuelStack.getItem().getContainerItem()));
                } else if (fuelStack.getCount() > 1) {
                    this.decrStackSize(this.fuelslot, 1);
                } else if (fuelStack.getCount() == 1) {
                    this.setInventorySlotContents(this.fuelslot, ItemStack.EMPTY);
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
            if (this.getStackInSlot(this.output).isEmpty()) {
                this.setInventorySlotContents(this.output, itemstack.copy());
            } else if (this.getStackInSlot(this.output).isItemEqual(itemstack)) {
                this.getStackInSlot(this.output).grow(itemstack.getCount());
            }
            if (this.getStackInSlot(this.input1).getCount() > 1) {
                this.decrStackSize(this.input1, 1);
            } else {
                this.setInventorySlotContents(this.input1, ItemStack.EMPTY);
            }
        }
    }

    public boolean canSmelt() {
        if (this.getStackInSlot(this.input1).isEmpty()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
        if (itemstack.isEmpty()) {
            return false;
        }
        if (this.getStackInSlot(this.output).isEmpty()) {
            return true;
        }
        if (!this.getStackInSlot(this.output).isItemEqual(itemstack)) {
            return false;
        }
        int result = this.getStackInSlot(this.output).getCount() + itemstack.getCount();
        return result <= this.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.instance().getSmeltingResult(stack);
        if (!result.isEmpty()) {
            return result.copy();
        }
        return ItemStack.EMPTY;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.fuel > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.fuel > 0), this.world, this.pos);
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        ItemStack fuelSlotStack;
        boolean isFuel = TileEntityFurnace.isItemFuel((ItemStack)stack);
        if (isFuel && ((fuelSlotStack = this.getStackInSlot(this.fuelslot)).isEmpty() || ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)fuelSlotStack, (boolean)true, (boolean)true) && fuelSlotStack.getMaxStackSize() != fuelSlotStack.getCount())) {
            return index == this.fuelslot;
        }
        return index != this.output;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getBurnTime() {
        return this.fuel;
    }

    public void setBurnTime(int burnTime) {
        this.fuel = burnTime;
    }

    public int getTotalBurnTime() {
        return this.fuelGague;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.fuelGague = totalBurnTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("ironfurnace").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).fuelSlot(2, 56, 53).slot(0, 56, 17).outputSlot(1, 116, 35).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }
}

