/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;

@RebornRegistry(modID="techreborn")
public class TileAssemblingMachine
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="assembling_machine", key="AssemblingMachineMaxInput", comment="Assembling Machine Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="assembling_machine", key="AssemblingMachineMaxEnergy", comment="Assembling Machine Max Energy (Value in EU)")
    public static int maxEnergy = 10000;

    public TileAssemblingMachine() {
        super("AssemblingMachine", maxInput, maxEnergy, ModBlocks.ASSEMBLY_MACHINE, 3);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2};
        this.inventory = new Inventory(4, "TileAssemblingMachine", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.ASSEMBLING_MACHINE_RECIPE, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("assemblingmachine").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 35).slot(1, 55, 55).outputSlot(2, 101, 45).energySlot(3, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }
}

