/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;

@RebornRegistry(modID="techreborn")
public class TileAutoCraftingTable
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterInput", comment="AutoCrafting Table Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterMaxEnergy", comment="AutoCrafting Table Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public Inventory inventory = new Inventory(11, "TileAutoCraftingTable", 64, (TileEntity)this);
    public int progress;
    public int maxProgress = 120;
    public int euTick = 10;
    InventoryCrafting inventoryCrafting = null;
    IRecipe lastCustomRecipe = null;
    IRecipe lastRecipe = null;
    public boolean locked = true;

    @Nullable
    public IRecipe getIRecipe() {
        InventoryCrafting crafting = this.getCraftingInventory();
        if (!crafting.isEmpty()) {
            if (this.lastRecipe != null && this.lastRecipe.matches(crafting, this.world)) {
                return this.lastRecipe;
            }
            for (IRecipe testRecipe : CraftingManager.REGISTRY) {
                if (!testRecipe.matches(crafting, this.world)) continue;
                this.lastRecipe = testRecipe;
                return testRecipe;
            }
        }
        return null;
    }

    public InventoryCrafting getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new InventoryCrafting(new Container(){

                public boolean canInteractWith(EntityPlayer playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.setInventorySlotContents(i, this.inventory.getStackInSlot(i));
        }
        return this.inventoryCrafting;
    }

    public boolean canMake(IRecipe recipe) {
        if (recipe != null && recipe.canFit(3, 3)) {
            boolean missingOutput = false;
            int[] stacksInSlots = new int[9];
            for (int i = 0; i < 9; ++i) {
                stacksInSlots[i] = this.inventory.getStackInSlot(i).getCount();
            }
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (ingredient == Ingredient.EMPTY) continue;
                boolean foundIngredient = false;
                for (int i = 0; i < 9; ++i) {
                    int requiredSize;
                    ItemStack stack = this.inventory.getStackInSlot(i);
                    int n = requiredSize = this.locked ? 1 : 0;
                    if (stack.getMaxStackSize() == 1) {
                        requiredSize = 0;
                    }
                    if (stacksInSlots[i] <= requiredSize || !ingredient.apply(stack) || stack.getItem().getContainerItem() != null && !this.hasRoomForExtraItem(stack.getItem().getContainerItem(stack))) continue;
                    foundIngredient = true;
                    int n2 = i;
                    stacksInSlots[n2] = stacksInSlots[n2] - 1;
                    break;
                }
                if (foundIngredient) continue;
                missingOutput = true;
            }
            return !missingOutput && this.hasOutputSpace(recipe.getRecipeOutput(), 9);
        }
        return false;
    }

    boolean hasRoomForExtraItem(ItemStack stack) {
        ItemStack extraOutputSlot = this.getStackInSlot(10);
        if (extraOutputSlot.isEmpty()) {
            return true;
        }
        return this.hasOutputSpace(stack, 10);
    }

    public boolean hasOutputSpace(ItemStack output, int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true) && stack.getMaxStackSize() > stack.getCount() + output.getCount();
    }

    public boolean make(IRecipe recipe) {
        if (recipe == null || !this.canMake(recipe)) {
            return false;
        }
        block0: for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            ItemStack bestSlot;
            Ingredient ingredient = (Ingredient)recipe.getIngredients().get(i);
            if (ingredient.apply(bestSlot = this.inventory.getStackInSlot(i))) {
                this.handleContainerItem(bestSlot);
                bestSlot.shrink(1);
                continue;
            }
            for (int j = 0; j < 9; ++j) {
                ItemStack stack = this.inventory.getStackInSlot(j);
                if (!ingredient.apply(stack)) continue;
                this.handleContainerItem(stack);
                stack.shrink(1);
                continue block0;
            }
        }
        ItemStack output = this.inventory.getStackInSlot(9);
        ItemStack ouputStack = recipe.getCraftingResult(this.getCraftingInventory());
        if (output.isEmpty()) {
            this.inventory.setInventorySlotContents(9, ouputStack.copy());
        } else {
            output.grow(recipe.getRecipeOutput().getCount());
        }
        return true;
    }

    private void handleContainerItem(ItemStack stack) {
        if (stack.getItem().hasContainerItem(stack)) {
            ItemStack containerItem = stack.getItem().getContainerItem(stack);
            ItemStack extraOutputSlot = this.getStackInSlot(10);
            if (this.hasOutputSpace(containerItem, 10)) {
                if (extraOutputSlot.isEmpty()) {
                    this.setInventorySlotContents(10, containerItem.copy());
                } else if (ItemUtils.isItemEqual((ItemStack)extraOutputSlot, (ItemStack)containerItem, (boolean)true, (boolean)true) && extraOutputSlot.getMaxStackSize() < extraOutputSlot.getCount() + containerItem.getCount()) {
                    extraOutputSlot.grow(1);
                }
            }
        }
    }

    public boolean hasIngredient(Ingredient ingredient) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!ingredient.apply(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemValidForRecipeSlot(IRecipe recipe, ItemStack stack, int slotID) {
        if (recipe == null) {
            return true;
        }
        int bestSlot = this.findBestSlotForStack(recipe, stack);
        if (bestSlot != -1) {
            return bestSlot == slotID;
        }
        return true;
    }

    public int findBestSlotForStack(IRecipe recipe, ItemStack stack) {
        if (recipe == null) {
            return -1;
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            Ingredient ingredient = (Ingredient)recipe.getIngredients().get(i);
            if (ingredient == Ingredient.EMPTY || !ingredient.apply(stack)) continue;
            if (stackInSlot.isEmpty()) {
                possibleSlots.add(i);
                continue;
            }
            if (stackInSlot.getItem() != stack.getItem() || stackInSlot.getItemDamage() != stack.getItemDamage() || stackInSlot.getMaxStackSize() < stackInSlot.getCount() + stack.getCount()) continue;
            possibleSlots.add(i);
        }
        Pair smallestCount = null;
        for (Integer slot : possibleSlots) {
            ItemStack slotStack = this.inventory.getStackInSlot(slot.intValue());
            if (slotStack.isEmpty()) {
                return slot;
            }
            if (smallestCount == null) {
                smallestCount = Pair.of((Object)slot, (Object)slotStack.getCount());
                continue;
            }
            if ((Integer)smallestCount.getRight() < slotStack.getCount()) continue;
            smallestCount = Pair.of((Object)slot, (Object)slotStack.getCount());
        }
        if (smallestCount != null) {
            return (Integer)smallestCount.getLeft();
        }
        return -1;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        IRecipe recipe = this.getIRecipe();
        if (recipe != null) {
            if (this.progress >= this.maxProgress) {
                if (this.make(recipe)) {
                    this.progress = 0;
                }
            } else if (this.canMake(recipe)) {
                if (this.canUseEnergy(this.euTick)) {
                    ++this.progress;
                    if (this.progress == 1) {
                        this.world.playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), ModSounds.AUTO_CRAFTING, SoundCategory.BLOCKS, 0.3f, 0.8f);
                    }
                    this.useEnergy(this.euTick);
                }
            } else {
                this.progress = 0;
            }
        }
        if (recipe == null) {
            this.progress = 0;
        }
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setBoolean("locked", this.locked);
        return super.writeToNBT(tag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("locked")) {
            this.locked = tag.getBoolean("locked");
        }
        super.readFromNBT(tag);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        int bestSlot = this.findBestSlotForStack(this.getIRecipe(), stack);
        if (bestSlot != -1) {
            return index == bestSlot;
        }
        return super.isItemValidForSlot(index, stack);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean canInsertItem(int index, ItemStack stack, EnumFacing direction) {
        if (index > 8) {
            return false;
        }
        int bestSlot = this.findBestSlotForStack(this.getIRecipe(), stack);
        if (bestSlot != -1) {
            return index == bestSlot;
        }
        return true;
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return index > 8;
    }

    public EnumFacing getFacingEnum() {
        return EnumFacing.NORTH;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.AUTO_CRAFTING_TABLE, 1);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("autocraftingtable").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getMaxProgress, this::setMaxProgress).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean hasSlotConfig() {
        return false;
    }
}

