/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileElectricFurnace
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="electric_furnace", key="ElectricFurnaceInput", comment="Electric Furnace Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="electric_furnace", key="ElectricFurnaceMaxEnergy", comment="Electric Furnace Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    public Inventory inventory = new Inventory(3, "TileElectricFurnace", 64, (TileEntity)this);
    public int progress;
    public int fuelScale = 100;
    public int cost = 6;
    int input1 = 0;
    int output = 1;
    boolean wasBurning = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / (int)((double)this.fuelScale * (1.0 - this.getSpeedMultiplier()));
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
            if (this.getStackInSlot(this.output).isEmpty()) {
                this.setInventorySlotContents(this.output, itemstack.copy());
            } else if (this.getStackInSlot(this.output).isItemEqual(itemstack)) {
                this.getStackInSlot(this.output).grow(itemstack.getCount());
            }
            if (this.getStackInSlot(this.input1).getCount() > 1) {
                this.decrStackSize(this.input1, 1);
            } else {
                this.setInventorySlotContents(this.input1, ItemStack.EMPTY);
            }
        }
    }

    public boolean canSmelt() {
        if (this.getStackInSlot(this.input1).isEmpty()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
        if (itemstack.isEmpty()) {
            return false;
        }
        if (this.getStackInSlot(this.output).isEmpty()) {
            return true;
        }
        if (!this.getStackInSlot(this.output).isItemEqual(itemstack)) {
            return false;
        }
        int result = this.getStackInSlot(this.output).getCount() + itemstack.getCount();
        return result <= this.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public boolean isBurning() {
        return this.getEnergy() > this.getEuPerTick(this.cost);
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.instance().getSmeltingResult(stack);
        if (!result.isEmpty()) {
            return result.copy();
        }
        return ItemStack.EMPTY;
    }

    public void updateState() {
        if (this.wasBurning != this.progress > 0) {
            if (this.wasBurning && this.progress == 0 && this.canSmelt()) {
                this.wasBurning = true;
                return;
            }
            IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
            if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
                BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
                if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                    blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.world, this.pos);
                }
            }
            this.wasBurning = this.progress > 0;
        }
    }

    public int getBurnTime() {
        return this.progress;
    }

    public void setBurnTime(int burnTime) {
        this.progress = burnTime;
    }

    public void update() {
        if (this.world.isRemote) {
            return;
        }
        super.update();
        this.charge(2);
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.isBurning() && this.canSmelt()) {
            this.updateState();
            if (this.canUseEnergy(this.getEuPerTick(this.cost))) {
                this.useEnergy(this.getEuPerTick(this.cost));
                ++this.progress;
                if (this.progress >= Math.max((int)((double)this.fuelScale * (1.0 - this.getSpeedMultiplier())), 5)) {
                    this.progress = 0;
                    this.cookItems();
                    updateInventory = true;
                }
            }
        } else {
            this.progress = 0;
            this.updateState();
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ELECTRIC_FURNACE, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("electricfurnace").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }
}

