/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.IToolDrop;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.WorldUtils;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TilePlayerDectector
extends TilePowerAcceptor
implements IToolDrop {
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorMaxInput", comment="Player Detector Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorMaxEnergy", comment="Player Detector Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    @ConfigRegistry(config="machines", category="player_detector", key="PlayerDetectorEUPerSecond", comment="Player Detector Energy Consumption per second (Value in EU)")
    public static int euPerTick = 10;
    public String owenerUdid = "";
    boolean redstone = false;

    public boolean isProvidingPower() {
        return this.redstone;
    }

    public void update() {
        super.update();
        if (!this.world.isRemote && this.world.getWorldTime() % 20L == 0L) {
            boolean lastRedstone = this.redstone;
            this.redstone = false;
            if (this.canUseEnergy(euPerTick)) {
                for (EntityPlayer player : this.world.playerEntities) {
                    if (!(player.getDistanceSq((double)super.getPos().getX() + 0.5, (double)super.getPos().getY() + 0.5, (double)super.getPos().getZ() + 0.5) <= 256.0)) continue;
                    BlockMachineBase blockMachineBase = (BlockMachineBase)this.world.getBlockState(this.pos).getBlock();
                    int meta = blockMachineBase.getMetaFromState(this.world.getBlockState(this.pos));
                    if (meta == 0) {
                        this.redstone = true;
                        continue;
                    }
                    if (meta == 1) {
                        if (this.owenerUdid.isEmpty() || this.owenerUdid.equals(player.getUniqueID().toString())) continue;
                        this.redstone = true;
                        continue;
                    }
                    if (this.owenerUdid.isEmpty() || !this.owenerUdid.equals(player.getUniqueID().toString())) continue;
                    this.redstone = true;
                }
                this.useEnergy(euPerTick);
            }
            if (lastRedstone != this.redstone) {
                WorldUtils.updateBlock((World)this.world, (BlockPos)this.pos);
                this.world.notifyNeighborsOfStateChange(this.pos, this.world.getBlockState(this.pos).getBlock(), true);
            }
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.owenerUdid = tag.getString("ownerID");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setString("ownerID", this.owenerUdid);
        return tag;
    }

    public ItemStack getToolDrop(EntityPlayer p0) {
        return new ItemStack(ModBlocks.PLAYER_DETECTOR, 1, 0);
    }
}

