/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileRollingMachine
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineMaxInput", comment="Rolling Machine Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineEnergyPerTick", comment="Rolling Machine Energy Per Tick (Value in EU)")
    public static int energyPerTick = 5;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineEnergyRunTime", comment="Rolling Machine Run Time")
    public static int runTime = 250;
    @ConfigRegistry(config="machines", category="rolling_machine", key="RollingMachineMaxEnergy", comment="Rolling Machine Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private InventoryCrafting craftCache;
    public Inventory inventory = new Inventory(12, "TileRollingMachine", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;
    @Nonnull
    public ItemStack currentRecipeOutput;
    public IRecipe currentRecipe;
    private int outputSlot = 9;
    public boolean locked = false;
    public int balanceSlot = 0;

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        this.charge(10);
        InventoryCrafting craftMatrix = this.getCraftingMatrix();
        this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(craftMatrix, this.world);
        if (this.currentRecipe != null) {
            Optional<InventoryCrafting> balanceResult;
            if (this.world.getTotalWorldTime() % 2L == 0L && (balanceResult = this.balanceRecipe(craftMatrix)).isPresent()) {
                craftMatrix = balanceResult.get();
            }
            this.currentRecipeOutput = this.currentRecipe.getCraftingResult(craftMatrix);
        } else {
            this.currentRecipeOutput = ItemStack.EMPTY;
        }
        if (!this.currentRecipeOutput.isEmpty() && this.canMake(craftMatrix)) {
            if (this.tickTime >= Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.currentRecipeOutput = RollingMachineRecipe.instance.findMatchingRecipeOutput(craftMatrix, this.world);
                if (!this.currentRecipeOutput.isEmpty()) {
                    boolean hasCrafted = false;
                    if (this.inventory.getStackInSlot(this.outputSlot).isEmpty()) {
                        this.inventory.setInventorySlotContents(this.outputSlot, this.currentRecipeOutput);
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else if (this.inventory.getStackInSlot(this.outputSlot).getCount() + this.currentRecipeOutput.getCount() <= this.currentRecipeOutput.getMaxStackSize()) {
                        ItemStack stack = this.inventory.getStackInSlot(this.outputSlot);
                        stack.setCount(stack.getCount() + this.currentRecipeOutput.getCount());
                        this.inventory.setInventorySlotContents(this.outputSlot, stack);
                        this.tickTime = 0;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
                            this.inventory.decrStackSize(i, 1);
                        }
                        this.currentRecipeOutput = ItemStack.EMPTY;
                        this.currentRecipe = null;
                    }
                }
            }
        } else {
            this.tickTime = 0;
        }
        if (!this.currentRecipeOutput.isEmpty() && this.canUseEnergy(this.getEuPerTick(energyPerTick)) && this.tickTime < Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) && this.canMake(craftMatrix)) {
            this.useEnergy(this.getEuPerTick(energyPerTick));
            ++this.tickTime;
        }
        if (this.currentRecipeOutput.isEmpty()) {
            this.tickTime = 0;
            this.currentRecipe = null;
        }
    }

    public Optional<InventoryCrafting> balanceRecipe(InventoryCrafting craftCache) {
        ItemStack sourceStack;
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        if (this.world.isRemote) {
            return Optional.empty();
        }
        if (!this.locked) {
            return Optional.empty();
        }
        if (craftCache.isEmpty()) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.getSizeInventory()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.getStackInSlot(this.balanceSlot)).isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int s = 0; s < this.currentRecipe.getIngredients().size(); ++s) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(s);
            Ingredient ingredient = (Ingredient)this.currentRecipe.getIngredients().get(s);
            if (ingredient == Ingredient.EMPTY || !ingredient.apply(sourceStack)) continue;
            if (stackInSlot.isEmpty()) {
                possibleSlots.add(s);
                continue;
            }
            if (stackInSlot.getItem() != sourceStack.getItem() || stackInSlot.getItemDamage() != sourceStack.getItemDamage()) continue;
            possibleSlots.add(s);
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            ItemStack slotStack = this.inventory.getStackInSlot(slot.intValue());
            if (slotStack.isEmpty()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.getCount());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.getCount()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.getCount());
        }
        if (bestSlot == null || (Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.getCount() || this.inventory.getStackInSlot(((Integer)bestSlot.getLeft()).intValue()).isEmpty() || !ItemUtils.isItemEqual((ItemStack)sourceStack, (ItemStack)this.inventory.getStackInSlot(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.shrink(1);
        this.inventory.getStackInSlot(((Integer)bestSlot.getLeft()).intValue()).grow(1);
        this.inventory.hasChanged = true;
        return Optional.of(this.getCraftingMatrix());
    }

    private InventoryCrafting getCraftingMatrix() {
        if (this.craftCache == null) {
            this.craftCache = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
        }
        if (this.inventory.hasChanged) {
            for (int i = 0; i < 9; ++i) {
                this.craftCache.setInventorySlotContents(i, this.inventory.getStackInSlot(i).copy());
            }
            this.inventory.hasChanged = false;
        }
        return this.craftCache;
    }

    public boolean canMake(InventoryCrafting craftMatrix) {
        ItemStack stack = RollingMachineRecipe.instance.findMatchingRecipeOutput(craftMatrix, this.world);
        if (this.locked) {
            for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
                ItemStack stack1 = craftMatrix.getStackInSlot(i);
                if (stack1.isEmpty() || stack1.getCount() >= 2) continue;
                return false;
            }
        }
        if (stack.isEmpty()) {
            return false;
        }
        ItemStack output = this.getStackInSlot(this.outputSlot);
        if (output.isEmpty()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ROLLING_MACHINE, 1);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.isRunning = tagCompound.getBoolean("isRunning");
        this.tickTime = tagCompound.getInteger("tickTime");
        this.locked = tagCompound.getBoolean("locked");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("isRunning", this.isRunning);
        tagCompound.setInteger("tickTime", this.tickTime);
        tagCompound.setBoolean("locked", this.locked);
        return tagCompound;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) == 0) {
            return 0;
        }
        return this.tickTime * scale / Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("rollingmachine").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 30, 22).slot(1, 48, 22).slot(2, 66, 22).slot(3, 30, 40).slot(4, 48, 40).slot(5, 66, 40).slot(6, 30, 58).slot(7, 48, 58).slot(8, 66, 58).onCraft(inv -> this.inventory.setInventorySlotContents(1, RollingMachineRecipe.instance.findMatchingRecipeOutput(this.getCraftingMatrix(), this.world))).outputSlot(9, 124, 40).energySlot(10, 8, 70).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((TileLegacyMachineBase)this);
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0 && Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1) != 0) {
            return this.tickTime * scale / Math.max((int)((double)runTime * (1.0 - this.getSpeedMultiplier())), 1);
        }
        return 0;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean canInteractWith(EntityPlayer entityplayer) {
            return true;
        }
    }
}

