/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtils {
    public static String toFirstLower(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String toFirstUpper(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String joinDictName(String prefix, String name) {
        return prefix + OreDictUtils.toFirstUpper(name);
    }

    public static String[] getDictData(String prefixed) {
        StringBuilder prefixBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        boolean prefixFinished = false;
        for (int i = 0; i < prefixed.length(); ++i) {
            char charAt = prefixed.charAt(i);
            if (!prefixFinished) {
                if (Character.isUpperCase(charAt)) {
                    nameBuilder.append(Character.toLowerCase(charAt));
                    prefixFinished = true;
                    continue;
                }
                prefixBuilder.append(charAt);
                continue;
            }
            nameBuilder.append(charAt);
        }
        return new String[]{prefixBuilder.toString(), nameBuilder.toString()};
    }

    public static boolean isDictPrefixed(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static ItemStack getDictOreOrEmpty(String name, int amount) {
        NonNullList ores = OreDictionary.getOres((String)name);
        if (ores.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack ore = ((ItemStack)ores.get(0)).copy();
        ore.setCount(amount);
        return ore;
    }

    public static boolean isOre(Block block, String oreName) {
        return OreDictUtils.isOre(new ItemStack(Item.getItemFromBlock((Block)block)), oreName);
    }

    public static boolean isOre(IBlockState state, String oreName) {
        return OreDictUtils.isOre(new ItemStack(Item.getItemFromBlock((Block)state.getBlock()), 1, state.getBlock().getMetaFromState(state)), oreName);
    }

    public static boolean isOre(Item item, String oreName) {
        return OreDictUtils.isOre(new ItemStack(item), oreName);
    }

    public static boolean isOre(@Nonnull ItemStack stack, String oreName) {
        if (!stack.isEmpty() && oreName != null) {
            int[] ids;
            int id = OreDictionary.getOreID((String)oreName);
            for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (id != i) continue;
                return true;
            }
        }
        return false;
    }
}

