/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world.village;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import techreborn.init.ModBlocks;
import techreborn.world.RubberTreeGenerator;
import techreborn.world.village.ModLootTables;

public class VillageComponentRubberPlantaion
extends StructureVillagePieces.Field1 {
    public static StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
        return VillageComponentRubberPlantaion.canVillageGoDeeper((StructureBoundingBox)structureboundingbox) && StructureComponent.findIntersecting(pieces, (StructureBoundingBox)structureboundingbox) == null ? new VillageComponentRubberPlantaion(startPiece, p5, random, structureboundingbox, facing) : null;
    }

    public VillageComponentRubberPlantaion() {
    }

    public VillageComponentRubberPlantaion(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox structureBoundingBox, EnumFacing facing) {
        super(start, type, rand, structureBoundingBox, facing);
    }

    protected void fillWithBlocks(World worldIn, StructureBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState boundaryBlockState, IBlockState insideBlockState, boolean existingOnly) {
        if (boundaryBlockState.getBlock() == Blocks.FARMLAND) {
            boundaryBlockState = Blocks.GRASS.getDefaultState();
            insideBlockState = Blocks.GRASS.getDefaultState();
        }
        if (boundaryBlockState.getBlock() == Blocks.WATER || boundaryBlockState.getBlock() == Blocks.LOG) {
            boundaryBlockState = Blocks.STONEBRICK.getDefaultState();
            insideBlockState = Blocks.STONEBRICK.getDefaultState();
        }
        super.fillWithBlocks(worldIn, boundingboxIn, xMin, yMin, zMin, xMax, yMax, zMax, boundaryBlockState, insideBlockState, existingOnly);
    }

    protected void setBlockState(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        if (this.isCrop(blockstateIn)) {
            blockstateIn = ModBlocks.RUBBER_SAPLING.getDefaultState();
        }
        super.setBlockState(worldIn, blockstateIn, x, y, z, boundingboxIn);
    }

    public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        super.addComponentParts(worldIn, randomIn, structureBoundingBoxIn);
        for (int i = 1; i < 7; ++i) {
            this.growRandom(i, 1, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 2, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 4, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 5, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 7, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 8, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 10, structureBoundingBoxIn, randomIn, worldIn);
            this.growRandom(i, 11, structureBoundingBoxIn, randomIn, worldIn);
        }
        this.generateChest(worldIn, structureBoundingBoxIn, randomIn, 0, 1, 0, ModLootTables.CHESTS_RUBBER_PLANTATION);
        return true;
    }

    private void growRandom(int coloum, int row, StructureBoundingBox structureBoundingBox, Random random, World world) {
        if (random.nextInt(10) == 0) {
            this.setBlockState(world, Blocks.AIR.getDefaultState(), row, 1, coloum, structureBoundingBox);
            BlockPos pos = new BlockPos(this.getXWithOffset(row, coloum), this.getYWithOffset(1), this.getZWithOffset(row, coloum));
            if (!new RubberTreeGenerator(true).growTree(world, random, pos.getX(), pos.getY(), pos.getZ())) {
                this.setBlockState(world, ModBlocks.RUBBER_SAPLING.getDefaultState(), row, 1, coloum, structureBoundingBox);
            }
        }
    }

    private boolean isCrop(IBlockState state) {
        return state.getBlock() instanceof BlockCrops;
    }
}

