/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.tiles.TileEntityFlare;

import java.util.List;

/**
 * Created by modmuss50 on 06/11/2016.
 */
public class BlockFlare extends BlockContainer {

	public static final AxisAlignedBB FLARE_BB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 0.1D, 1.0D);

	public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a("color", EnumDyeColor.class);

	public BlockFlare() {
		super(Material.field_151591_t);
		func_149647_a(TechRebornCreativeTab.instance);
		func_149663_c("techreborn.flare");
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, EnumDyeColor.WHITE));
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		if (worldIn.field_72995_K) { //Only needed on the client
			return new TileEntityFlare();
		}
		return null;
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return (state.func_177229_b(COLOR)).func_176765_a();
	}

	@SideOnly(Side.CLIENT)
	public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
		for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
			list.add(new ItemStack(itemIn, 1, enumdyecolor.func_176765_a()));
		}
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(COLOR, EnumDyeColor.func_176764_b(meta));
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return (state.func_177229_b(COLOR)).func_176765_a();
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, COLOR);
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT;
	}

	public boolean isFullCube() {
		return false;
	}

	@Override
	public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
		return FLARE_BB;
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
		return FLARE_BB;
	}
}
