/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.Torus;
import techreborn.client.EGui;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.init.ModBlocks;
import techreborn.lib.ModInfo;
import techreborn.tiles.fusionReactor.TileFusionControlComputer;
import techreborn.utils.damageSources.FusionDamageSource;

import java.util.List;

public class BlockFusionControlComputer extends BlockMachineBase {

	public BlockFusionControlComputer() {
		super();
		func_149647_a(TechRebornCreativeTab.instance);
		ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this, "machines/generators"));
	}

	@Override
	public boolean func_180639_a(final World world, final BlockPos pos, final IBlockState state,
									final EntityPlayer player, final EnumHand hand, final EnumFacing side,
									final float hitX, final float hitY, final float hitZ) {
		final TileFusionControlComputer tileFusionControlComputer = (TileFusionControlComputer) world.func_175625_s(pos);
		if(!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == Item.func_150898_a(ModBlocks.FUSION_COIL)){
			List<BlockPos> coils = Torus.generate(tileFusionControlComputer.func_174877_v(), tileFusionControlComputer.size);
			boolean placed = false;
			for(BlockPos coil : coils){
				if(player.func_184586_b(hand).func_190926_b()){
					return true;
				}
				if(world.func_175623_d(coil) && !tileFusionControlComputer.isCoil(coil)){
					world.func_175656_a(coil, ModBlocks.FUSION_COIL.func_176223_P());
					if(!player.func_184812_l_()){
						player.func_184586_b(hand).func_190918_g(1);
					}
					placed = true;
				}
			}
			if(placed){
				return true;
			}

		}
		tileFusionControlComputer.checkCoils();
		return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
	}

	@Override
	public IMachineGuiHandler getGui() {
		return EGui.FUSION_CONTROLLER;
	}

	@Override
	public void func_176199_a(final World worldIn, final BlockPos pos, final Entity entityIn) {
		super.func_176199_a(worldIn, pos, entityIn);
		if (worldIn.func_175625_s(pos) instanceof TileFusionControlComputer) {
			if (((TileFusionControlComputer) worldIn.func_175625_s(pos)).crafingTickTime != 0
					&& ((TileFusionControlComputer) worldIn.func_175625_s(pos)).checkCoils()) {
				entityIn.func_70097_a(new FusionDamageSource(), 200F);
			}
		}
	}

	@Override
	public TileEntity func_149915_a(final World world, final int meta) {
		return new TileFusionControlComputer();
	}
	
	@Override
	public boolean isAdvanced() {
		return true;
	}
}
