/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.BaseBlock;
import techreborn.entities.EntityNukePrimed;
import techreborn.lib.ModInfo;
import techreborn.utils.TechRebornCreativeTab;

/**
 * Created by Mark on 13/03/2016.
 */
public class BlockNuke extends BaseBlock {
	public static final PropertyBool OVERLAY = PropertyBool.func_177716_a("overlay");

	public BlockNuke() {
		super(Material.field_151590_u);
		func_149663_c("techreborn.nuke");
		func_149647_a(TechRebornCreativeTab.instance);
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(OVERLAY, false));
		ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this));
	}

	public void ignite(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
		if (!worldIn.field_72995_K) {
			EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (double) ((float) pos.func_177958_n() + 0.5F),
					(double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), igniter);
			worldIn.func_72838_d(entitynukeprimed);
			worldIn.func_184148_a((EntityPlayer) null, entitynukeprimed.field_70165_t, entitynukeprimed.field_70163_u, entitynukeprimed.field_70161_v,
					SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0F, 1.0F);
		}
	}

	@Override
	public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
		if (!worldIn.field_72995_K) {
			EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (double) ((float) pos.func_177958_n() + 0.5F),
					(double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), explosionIn.func_94613_c());
			entitynukeprimed.func_184534_a(worldIn.field_73012_v.nextInt(EntityNukePrimed.fuseTime / 4) + EntityNukePrimed.fuseTime / 8);
			worldIn.func_72838_d(entitynukeprimed);
		}
	}

	@Override
	public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
		if (!worldIn.field_72995_K && entityIn instanceof EntityArrow) {
			EntityArrow entityarrow = (EntityArrow) entityIn;
			EntityLivingBase shooter = null;
			if (entityarrow.field_70250_c instanceof EntityLivingBase) {
				shooter = (EntityLivingBase) entityarrow.field_70250_c;
			}
			if (entityarrow.func_70027_ad()) {
				ignite(worldIn, pos, state, shooter);
				worldIn.func_175698_g(pos);
			}
		}
	}

	@Override
	public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
		super.func_176213_c(worldIn, pos, state);
		if (worldIn.func_175640_z(pos)) {
			ignite(worldIn, pos, state, null);
			worldIn.func_175698_g(pos);
		}
	}

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
		if (worldIn.func_175640_z(pos)) {
			ignite(worldIn, pos, state, null);
			worldIn.func_175698_g(pos);
		}
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn,
			EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
		return false;
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(OVERLAY) ? 1 : 0;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(OVERLAY, (meta & 1) > 0);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, OVERLAY);
	}

}
