/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.StringUtils;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModBlocks;
import techreborn.lib.ModInfo;
import techreborn.world.config.IOreNameProvider;

import java.security.InvalidParameterException;
import java.util.List;

public class BlockOre2 extends Block implements IOreNameProvider {

	public static final String[] ores = new String[] { "copper", "tin" };
	static List<String> oreNamesList = Lists.newArrayList(ArrayUtils.arrayToLowercase(ores));
	public PropertyString VARIANTS;

	public BlockOre2() {
		super(Material.field_151576_e);
		func_149647_a(TechRebornCreativeTab.instance);
		func_149711_c(2.0f);
		setHarvestLevel("pickaxe", 1);
		this.func_180632_j(this.func_176203_a(0));
		for (int i = 0; i < ores.length; i++) {
			ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this, i).setInvVariant("type=" + ores[i]).setFileName("ores"));
		}
		TRRecipeHandler.hideEntry(this);
	}

	public static ItemStack getOreByName(String name, int count) {
		for (int i = 0; i < ores.length; i++) {
			if (ores[i].equalsIgnoreCase(name)) {
				return new ItemStack(ModBlocks.ORE2, count, i);
			}
		}
		throw new InvalidParameterException("The ore block " + name + " could not be found.");
	}

	public static ItemStack getOreByName(String name) {
		return getOreByName(name, 1);
	}

	public IBlockState getBlockStateFromName(String name) {
		int index = -1;
		for (int i = 0; i < ores.length; i++) {
			if (ores[i].equalsIgnoreCase(name)) {
				index = i;
				break;
			}
		}
		if (index == -1) {
			throw new InvalidParameterException("The ore block " + name + " could not be found.");
		}
		return func_176203_a(index);
	}

	@Override
	protected boolean func_149700_E() {
		return true;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
		for (int meta = 0; meta < ores.length; meta++) {
			list.add(new ItemStack(this, 1, meta));
		}
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos,
	                              EntityPlayer player) {
		return new ItemStack(this, 1, func_176201_c(state));
	}

	//	@Override
	//	public int damageDropped(IBlockState state)
	//	{
	//		int meta = getMetaFromState(state);
	//		if (meta == 2)
	//		{
	//			return 0;
	//		} else if (meta == 3)
	//		{
	//			return 1;
	//		} else if (meta == 5)
	//		{
	//			return 60;
	//		}
	//		return meta;
	//	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		if (meta > ores.length) {
			meta = 0;
		}
		return func_176194_O().func_177621_b().func_177226_a(VARIANTS, oreNamesList.get(meta));
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return oreNamesList.indexOf(state.func_177229_b(VARIANTS));
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		VARIANTS = new PropertyString("type", oreNamesList);
		return new BlockStateContainer(this, VARIANTS);
	}

	@Override
	public String getUserLoclisedName(IBlockState state) {
		return StringUtils.toFirstCapital(oreNamesList.get(func_176201_c(state)));
	}
}
