/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import techreborn.Core;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.init.ModBlocks;
import techreborn.lib.ModInfo;

import java.util.List;
import java.util.Random;

public class BlockRubberLeaves extends BlockLeaves {

	public BlockRubberLeaves() {
		super();
		func_149647_a(TechRebornCreativeTab.instance);
		this.func_180632_j(this.func_176223_P().func_177226_a(field_176236_b, true)
			.func_177226_a(field_176237_a, true));
		Blocks.field_150480_ab.func_180686_a(this, 30, 60);
		ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this, field_176236_b, field_176237_a));
	}

	@Override
	public BlockPlanks.EnumType func_176233_b(int meta) {
		return null;
	}

	@Override
	public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
		List<ItemStack> list = new java.util.ArrayList<>();
		list.add(new ItemStack(this, 1, 0));
		return list;
	}

	@Override
	public BlockRenderLayer func_180664_k() {
		if(!fancyLeaves()){
			return super.func_180664_k();
		}
		return BlockRenderLayer.CUTOUT_MIPPED;
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		if(!fancyLeaves()){
			return super.func_149662_c(state);
		}
		return false;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, new IProperty[] { field_176236_b, field_176237_a });
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(field_176237_a, (meta & 1) == 0)
			.func_177226_a(field_176236_b, (meta & 2) > 0);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int meta = 0;
		if (!state.func_177229_b(field_176237_a)) {
			meta |= 1;
		}
		if (state.func_177229_b(field_176236_b)) {
			meta |= 2;
		}
		return meta;
	}

	@SideOnly(Side.CLIENT)
	public int getBlockColor() {
		return 16777215;
	}

	@SideOnly(Side.CLIENT)
	public int getRenderColor(IBlockState state) {
		return 16777215;
	}

	@SideOnly(Side.CLIENT)
	public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
		return 16777215;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return Item.func_150898_a(ModBlocks.RUBBER_SAPLING);
	}

	@Override
	public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
		if(!fancyLeaves()){
			return super.func_176225_a(blockState, blockAccess, pos, side);
		}
		return true;
	}

	public boolean fancyLeaves(){
		return Core.proxy.fancyGraphics();
	}
}
