/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.WorldUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModSounds;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.tools.ItemElectricTreetap;
import techreborn.items.tools.ItemTreeTap;
import techreborn.lib.ModInfo;
import techreborn.utils.TechRebornCreativeTab;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Created by modmuss50 on 19/02/2016.
 */
public class BlockRubberLog extends Block {

	public static PropertyDirection SAP_SIDE = PropertyDirection.func_177712_a("sapside", EnumFacing.Plane.HORIZONTAL);
	public static PropertyBool HAS_SAP = PropertyBool.func_177716_a("hassap");

	public BlockRubberLog() {
		super(Material.field_151575_d);
		func_149647_a(TechRebornCreativeTab.instance);
		this.func_149711_c(2.0F);
		this.func_180632_j(
			this.func_176223_P().func_177226_a(SAP_SIDE, EnumFacing.NORTH).func_177226_a(HAS_SAP, false));
		this.func_149675_a(true);
		this.func_149672_a(SoundType.field_185848_a);
		Blocks.field_150480_ab.func_180686_a(this, 5, 5);
		ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this));
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, SAP_SIDE, HAS_SAP);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		boolean hasSap = false;
		int tempMeta = meta;
		if (meta > 3) {
			hasSap = true;
			tempMeta -= 3;
		}
		EnumFacing facing = EnumFacing.func_176731_b(tempMeta);
		return this.func_176223_P().func_177226_a(SAP_SIDE, facing).func_177226_a(HAS_SAP, hasSap);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int tempMeta = 0;
		EnumFacing facing = state.func_177229_b(SAP_SIDE);
		switch (facing) {
			case SOUTH:
				tempMeta = 0;
				break;
			case WEST:
				tempMeta = 1;
				break;
			case NORTH:
				tempMeta = 2;
				break;
			case EAST:
				tempMeta = 3;
				break;
			case UP:
				tempMeta = 0;
				break;
			case DOWN:
				tempMeta = 0;
		}
		if (state.func_177229_b(HAS_SAP)) {
			tempMeta += 4;
		}
		return tempMeta;
	}

	@Override
	public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
		return true;
	}

	@Override
	public boolean isWood(net.minecraft.world.IBlockAccess world, BlockPos pos) {
		return true;
	}

	@Override
	public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
		int i = 4;
		int j = i + 1;
		if (worldIn.func_175707_a(pos.func_177982_a(-j, -j, -j), pos.func_177982_a(j, j, j))) {
			for (BlockPos blockpos : BlockPos.func_177980_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i))) {
				IBlockState state1 = worldIn.func_180495_p(blockpos);
				if (state1.func_177230_c().isLeaves(state1, worldIn, blockpos)) {
					state1.func_177230_c().beginLeavesDecay(state1, worldIn, blockpos);
				}
			}
		}
	}

	@Override
	public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
		super.func_180650_b(worldIn, pos, state, rand);
		if (!state.func_177229_b(HAS_SAP)) {
			if (rand.nextInt(50) == 0) {
				EnumFacing facing = EnumFacing.func_176731_b(rand.nextInt(4));
				if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this
					&& worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
					worldIn.func_175656_a(pos, state.func_177226_a(HAS_SAP, true).func_177226_a(SAP_SIDE, facing));
				}
			}
		}
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn,
	                                EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
		super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
		ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
		if (stack.func_190926_b()) {
			return false;
		}
		ForgePowerItemManager capEnergy = null;
		if (stack.func_77973_b() instanceof ItemElectricTreetap) {
			capEnergy = new ForgePowerItemManager(stack);
		}
		if ((capEnergy != null && capEnergy.getEnergyStored() > 20) || stack.func_77973_b() instanceof ItemTreeTap) {
			if (state.func_177229_b(HAS_SAP) && state.func_177229_b(SAP_SIDE) == side) {
				worldIn.func_175656_a(pos,
					state.func_177226_a(HAS_SAP, false).func_177226_a(SAP_SIDE, EnumFacing.func_176731_b(0)));
				worldIn.func_184148_a(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ModSounds.SAP_EXTRACT, SoundCategory.BLOCKS,
					0.6F, 1F);
				if (!worldIn.field_72995_K) {
					if (capEnergy != null) {
						capEnergy.extractEnergy(20, false);

						ExternalPowerSystems.requestEnergyFromArmor(capEnergy, playerIn);
					} else {
						playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77972_a(1, playerIn);
					}
					if (!playerIn.field_71071_by.func_70441_a(ItemParts.getPartByName("rubberSap").func_77946_l())) {
						WorldUtils.dropItem(ItemParts.getPartByName("rubberSap").func_77946_l(), worldIn, pos.func_177972_a(side));
					}
					if (playerIn instanceof EntityPlayerMP) {
						TRRecipeHandler.unlockTRRecipes((EntityPlayerMP) playerIn);
					}
				}
				return true;
			}
		}
		return false;
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return 0;
	}

	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		List<ItemStack> drops = new ArrayList<>();
		drops.add(new ItemStack(this));
		if (state.func_177229_b(HAS_SAP)) {
			if (new Random().nextInt(4) == 0) {
				drops.add(ItemParts.getPartByName("rubberSap"));
			}
		}
		return drops;
	}
}
