/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import techreborn.lib.ModInfo;
import techreborn.utils.TechRebornCreativeTab;

import java.util.Random;

import net.minecraft.block.BlockSlab.EnumBlockHalf;

//Thanks @Prospector you saved me me some time :)
public abstract class BlockRubberPlankSlab extends BlockSlab {
	public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a("variant", BlockRubberPlankSlab.Variant.class);
	public final String name;
	public Block halfslab;

	public BlockRubberPlankSlab(String name) {
		super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
		this.name = name;
		IBlockState iblockstate = this.field_176227_L.func_177621_b();
		if (!this.func_176552_j()) {
			iblockstate = iblockstate.func_177226_a(field_176554_a, EnumBlockHalf.BOTTOM);
			halfslab = this;
		}
		func_149647_a(TechRebornCreativeTab.instance);
		setHarvestLevel("axe", 0);
		func_149711_c(2.0F);
		func_149752_b(15);
		func_149672_a(SoundType.field_185848_a);
		this.func_180632_j(iblockstate.func_177226_a(VARIANT, BlockRubberPlankSlab.Variant.DEFAULT));
		field_149783_u = true;
		ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this));
	}

	@Override
	public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return true;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return Item.func_150898_a(halfslab);
	}

	@Override
	public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
		return new ItemStack(halfslab);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, BlockRubberPlankSlab.Variant.DEFAULT);

		if (!this.func_176552_j()) {
			iblockstate = iblockstate.func_177226_a(field_176554_a, (meta & 8) == 0 ? EnumBlockHalf.BOTTOM : EnumBlockHalf.TOP);
		}

		return iblockstate;
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int i = 0;

		if (!this.func_176552_j() && state.func_177229_b(field_176554_a) == EnumBlockHalf.TOP) {
			i |= 8;
		}

		return i;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return this.func_176552_j() ? new BlockStateContainer(this, new IProperty[] { VARIANT }) : new BlockStateContainer(this, new IProperty[] { field_176554_a, VARIANT });
	}

	@Override
	public String func_150002_b(int meta) {
		return super.func_149739_a();
	}

	@Override
	public IProperty<?> func_176551_l() {
		return VARIANT;
	}

	@Override
	public Comparable<?> func_185674_a(ItemStack stack) {
		return BlockRubberPlankSlab.Variant.DEFAULT;
	}

	public static enum Variant implements IStringSerializable {
		DEFAULT;

		@Override
		public String func_176610_l() {
			return "default";
		}
	}

	public static class BlockDouble extends BlockRubberPlankSlab {
		public BlockDouble(String name, Block half) {
			super(name);
			this.halfslab = half;
		}

		@Override
		public boolean func_176552_j() {
			return true;
		}
	}

	public static class BlockHalf extends BlockRubberPlankSlab {
		public BlockHalf(String name) {
			super(name);
		}

		@Override
		public boolean func_176552_j() {
			return false;
		}
	}
}
