/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.blocks.generator.solarpanel;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.lib.ModInfo;
import techreborn.tiles.generator.TileSolarPanel;

/**
 * Created by modmuss50 on 25/02/2016.
 */
public class BlockSolarPanel extends BlockMachineBase {
	public static final String[] panes = new String[] {
		"basic", "hybrid", "advanced", "ultimate", "quantum"};
	public static PropertyBool ACTIVE = PropertyBool.func_177716_a("active");
	public static final IProperty<EnumPanelType> TYPE = PropertyEnum.func_177709_a("type", EnumPanelType.class);

	public BlockSolarPanel() {
		super(true);
		func_149647_a(TechRebornCreativeTab.instance);
		this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(ACTIVE, false).func_177226_a(TYPE, EnumPanelType.Basic));
		for (int i = 0; i < panes.length; i++) {
			ShootingStar.registerModel(new ModelCompound(ModInfo.MOD_ID, this, i, "machines/generators").setInvVariant("active=false,type=" + panes[i]));
		}
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int active = state.func_177229_b(ACTIVE) ? EnumPanelType.values().length : 0;
		return state.func_177229_b(TYPE).ordinal() + active;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, ACTIVE, TYPE);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		boolean active = false;
		if(meta >= EnumPanelType.values().length){
			active = true;
			meta -= EnumPanelType.values().length;
		}
		return func_176223_P().func_177226_a(ACTIVE, active).func_177226_a(TYPE, EnumPanelType.values()[meta]);
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		return new TileSolarPanel(func_176203_a(meta).func_177229_b(TYPE));
	}

	@Override
	public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
		return func_176203_a(placer.func_184586_b(hand).func_77952_i());
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		//return new ItemStack(Item.getItemFromBlock(this), 1, getMetaFromState(world.getBlockState(pos)));
		return new ItemStack(Item.func_150898_a(this), 1, world.func_180495_p(pos).func_177229_b(TYPE).ordinal());
	}
	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(TYPE).ordinal();
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (EnumPanelType panelType : EnumPanelType.values()) {
			list.add(new ItemStack(this, 1, panelType.ordinal()));
		}
	}

	@Override
	public IMachineGuiHandler getGui() {
		return null;
	}
}
