/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import reborncore.client.gui.builder.GuiBase;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.client.gui.builder.widget.GuiButtonUpDown;
import techreborn.packets.PacketAesu;
import techreborn.tiles.storage.TileAdjustableSU;

import java.io.IOException;

import reborncore.client.gui.builder.GuiBase.Layer;
import reborncore.client.gui.builder.GuiBase.SlotConfigType;

public class GuiAESU extends GuiBase {

	TileAdjustableSU tile;

	public GuiAESU(final EntityPlayer player, final TileAdjustableSU aesu) {
		super(player, aesu, aesu.createContainer(player));
		this.tile = aesu;
	}

	@Override
	protected void func_146976_a(final float f, final int mouseX, final int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		drawSlot(62, 45, layer);
		drawSlot(98, 45, layer);
		drawArmourSlots(8, 18, layer);
		builder.drawEnergyOutput(this, 155, 61, tile.getCurrentOutput(), layer);
		builder.drawUpDownButtons(this, 121, 79, layer);
	}

	@Override
	protected void func_146979_b(final int mouseX, final int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		if(GuiBase.slotConfigType == SlotConfigType.NONE){
			GlStateManager.func_179094_E();
			GlStateManager.func_179139_a(0.6, 0.6, 1);
			drawCentredString(PowerSystem.getLocaliszedPowerFormattedNoSuffix((int) tile.getEnergy()) + "/"
				+ PowerSystem.getLocaliszedPowerFormattedNoSuffix((int) tile.getMaxPower()) + " "
				+ PowerSystem.getDisplayPower().abbreviation, 35, 0, 58, layer);
			GlStateManager.func_179121_F();
		}
	
		builder.drawMultiEnergyBar(this, 81, 28, (int) tile.getEnergy(), (int) tile.getMaxPower(), mouseX, mouseY, 0, layer);
		
		field_146292_n.add(new GuiButtonUpDown(300, 121, 79, this, layer));
		field_146292_n.add(new GuiButtonUpDown(301, 121 + 12, 79, this, layer));
		field_146292_n.add(new GuiButtonUpDown(302, 121 + 24, 79, this, layer));
		field_146292_n.add(new GuiButtonUpDown(303, 121 + 36, 79, this, layer));
	}
	
	@Override
	public void func_146284_a(final GuiButton button) throws IOException {
		super.func_146284_a(button);
		if (button.field_146127_k >= 300 && button.field_146127_k <= 303) {
			NetworkManager.sendToServer(new PacketAesu(button.field_146127_k, tile));
		} 
	}
}
