/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import techreborn.tiles.tier0.TileIronAlloyFurnace;

public class GuiAlloyFurnace extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation("techreborn",
		"textures/gui/alloy_furnace.png");

	TileIronAlloyFurnace alloyfurnace;

	public GuiAlloyFurnace(final EntityPlayer player, final TileIronAlloyFurnace alloyFurnace) {
		super(alloyFurnace.createContainer(player));
		this.field_146999_f = 176;
		this.field_147000_g = 167;
		this.alloyfurnace = alloyFurnace;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
	}

	@Override
	protected void func_146976_a(final float p_146976_1_, final int p_146976_2_, final int p_146976_3_) {
		this.func_146276_q_();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(GuiAlloyFurnace.texture);
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);

		if (this.alloyfurnace.isBurning()) {
			int i1 = this.alloyfurnace.getBurnTimeRemainingScaled(13);
			this.func_73729_b(k + 56, l + 36 + 12 - i1, 176, 12 - i1, 14, i1 + 1);
			i1 = this.alloyfurnace.getCookProgressScaled(24);
			this.func_73729_b(k + 79, l + 34, 176, 14, i1 + 1, 16);
		}
	}

	@Override
	protected void func_146979_b(final int p_146979_1_, final int p_146979_2_) {
		final String name = I18n.func_135052_a("tile.techreborn.iron_alloy_furnace.name");
		this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6,
			4210752);
		this.field_146289_q.func_78276_b(I18n.func_135052_a("container.inventory", new Object[0]), 8,
			this.field_147000_g - 96 + 2, 4210752);
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		super.func_73863_a(mouseX, mouseY, partialTicks);
		this.func_191948_b(mouseX, mouseY);
	}
}
