/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.ClientProxy;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.TileIndustrialBlastFurnace;

import java.io.IOException;

import reborncore.client.gui.builder.GuiBase.Layer;
import reborncore.client.gui.builder.GuiBase.SlotConfigType;

public class GuiBlastFurnace extends GuiBase {

	public TileIndustrialBlastFurnace tile;
	boolean hasMultiBlock;

	public GuiBlastFurnace(final EntityPlayer player, final TileIndustrialBlastFurnace tile) {
		super(player, tile, tile.createContainer(player));
		this.tile = tile;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.hasMultiBlock = this.tile.getCachedHeat() != 0;
		ClientProxy.multiblockRenderEvent.setMultiblock(null);
	}

	@Override
	protected void func_146976_a(final float f, final int mouseX, final int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);
		this.hasMultiBlock = this.tile.getCachedHeat() != 0;

		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		final GuiBase.Layer layer = Layer.BACKGROUND;
		
		drawSlot(8, 72, layer);
		
		drawSlot(50, 27, layer);
		drawSlot(50, 47, layer);
		drawOutputSlotBar(92, 36, 2, layer);

		builder.drawJEIButton(this, 158, 5, layer);
		if (hasMultiBlock) {
			builder.drawHologramButton(this, 6, 4, mouseX, mouseY, layer);
		}
	}

	@Override
	protected void func_146979_b(final int mouseX, final int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		this.hasMultiBlock = tile.getCachedHeat() != 0;
		final GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;

		builder.drawProgressBar(this, tile.getProgressScaled(100), 100, 71, 40, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);

		builder.drawBigHeatBar(this, 31, 71, tile.getCachedHeat(), 3230, layer);
		if (hasMultiBlock) {
			addHologramButton(4, 4, 212, layer);
		} else {
			builder.drawMultiblockMissingBar(this, layer);
			addHologramButton(76, 56, 212, layer);
			builder.drawHologramButton(this, 76, 56, mouseX, mouseY, layer);
		}
		builder.drawMultiEnergyBar(this, 9, 19, (int) tile.getEnergy(), (int) tile.getMaxPower(), mouseX, mouseY, 0, layer);
	}

	@Override
	public void func_146284_a(final GuiButton button) throws IOException {
		super.func_146284_a(button);
		if (button.field_146127_k == 212 && GuiBase.slotConfigType == SlotConfigType.NONE) {
			if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
				{
					// This code here makes a basic multiblock and then sets to the selected one.
					final Multiblock multiblock = new Multiblock();
					addComponent(0, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					addComponent(1, 1, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 1, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					addComponent(1, 2, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 2, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					addComponent(0, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(0, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(-1, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					addComponent(1, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					final MultiblockSet set = new MultiblockSet(multiblock);
					ClientProxy.multiblockRenderEvent.setMultiblock(set);
					ClientProxy.multiblockRenderEvent.parent = tile.func_174877_v();
					MultiblockRenderEvent.anchor = new BlockPos(
							tile.func_174877_v().func_177958_n() - EnumFacing.func_82600_a(tile.getFacingInt()).func_82601_c() * 2,
							tile.func_174877_v().func_177956_o() - 1,
							tile.func_174877_v().func_177952_p() - EnumFacing.func_82600_a(tile.getFacingInt()).func_82599_e() * 2);
				}
			} else {
				ClientProxy.multiblockRenderEvent.setMultiblock(null);
			}
		}
	}

	public void addComponent(final int x, final int y, final int z, final IBlockState blockState, final Multiblock multiblock) {
		multiblock.addComponent(new BlockPos(x, y, z), blockState);
	}

}
