/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import techreborn.tiles.TileChunkLoader;

public class GuiChunkLoader extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation("techreborn",
		"textures/gui/industrial_chunkloader.png");
	TileChunkLoader chunkloader;
	private GuiButton plusOneButton;
	private GuiButton plusTenButton;
	private GuiButton minusOneButton;
	private GuiButton minusTenButton;

	public GuiChunkLoader(final EntityPlayer player, final TileChunkLoader chunkLoader) {
		super(chunkLoader.createContainer(player));
		this.field_146999_f = 176;
		this.field_147000_g = 167;
		this.chunkloader = chunkLoader;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.field_147003_i = this.field_146294_l / 2 - this.field_146999_f / 2;
		this.field_147009_r = this.field_146295_m / 2 - this.field_147000_g / 2;
		this.plusOneButton = new GuiButton(0, this.field_147003_i + 5, this.field_147009_r + 37, 40, 20, "+1");
		this.plusTenButton = new GuiButton(0, this.field_147003_i + 45, this.field_147009_r + 37, 40, 20, "+10");

		this.minusOneButton = new GuiButton(0, this.field_147003_i + 90, this.field_147009_r + 37, 40, 20, "-1");
		this.minusTenButton = new GuiButton(0, this.field_147003_i + 130, this.field_147009_r + 37, 40, 20, "-10");

		this.field_146292_n.add(this.plusOneButton);
		this.field_146292_n.add(this.plusTenButton);
		this.field_146292_n.add(this.minusOneButton);
		this.field_146292_n.add(this.minusTenButton);
	}

	@Override
	protected void func_146976_a(final float p_146976_1_, final int p_146976_2_, final int p_146976_3_) {
		this.func_146276_q_();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(GuiChunkLoader.texture);
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
	}

	@Override
	protected void func_146979_b(final int p_146979_1_, final int p_146979_2_) {
		final String name = I18n.func_135052_a("tile.techreborn:chunk_loader.name");
		this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6,
			4210752);
		this.field_146289_q.func_78276_b(I18n.func_135052_a("container.inventory", new Object[0]), 8,
			this.field_147000_g - 96 + 2, 4210752);
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		super.func_73863_a(mouseX, mouseY, partialTicks);
		this.func_191948_b(mouseX, mouseY);
	}

}
