/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiDestructoPack extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation("techreborn",
		"textures/gui/destructopack.png");

	public GuiDestructoPack(Container container) {
		super(container);
		this.field_146999_f = 176;
		this.field_147000_g = 166;
	}

	@Override
	protected void func_146976_a(float arg0, int arg1, int arg2) {
		this.func_146276_q_();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
		func_73729_b(field_147003_i, field_147009_r, 0, 0, 176, 166);
	}

	@Override
	protected void func_146979_b(int arg0, int arg1) {
		String name = I18n.func_135052_a("item.techreborn.part.destructoPack.name");
		field_146289_q.func_78276_b(name, field_146999_f / 2 - field_146289_q.func_78256_a(name) / 2, 5, 4210752);
		this.field_146289_q.func_78276_b(I18n.func_135052_a("container.inventory"), 8, this.field_147000_g - 96 + 2,
			4210752);
		super.func_146979_b(arg0, arg1);
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		super.func_73863_a(mouseX, mouseY, partialTicks);
		this.func_191948_b(mouseX, mouseY);
	}
}
