/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import reborncore.client.gui.builder.GuiBase;
import techreborn.init.ModItems;
import techreborn.tiles.tier0.TileIronFurnace;

public class GuiIronFurnace extends GuiBase {

	public static final ResourceLocation texture = new ResourceLocation("minecraft",
		"textures/gui/container/furnace.png");

	TileIronFurnace furnace;

	public GuiIronFurnace(final EntityPlayer player, final TileIronFurnace furnace) {
		super(player, furnace,  furnace.createContainer(player));
		this.xSize = 176;
		this.ySize = 167;
		this.furnace = furnace;
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		func_146276_q_();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		builder.drawSlotTab(this, field_147003_i - 24, field_147009_r + 6, new ItemStack(ModItems.WRENCH));
		field_146297_k.func_110434_K().func_110577_a(GuiIronFurnace.texture);
		final int k = (this.field_146294_l - xSize) / 2;
		final int l = (this.field_146295_m - ySize) / 2;
		func_73729_b(k, l, 0, 0, xSize, ySize);

		int j = 0;

		j = furnace.gaugeProgressScaled(24);
		if (j > 0) {
			func_73729_b(k + 78, l + 35, 176, 14, j + 1, 16);
		}

		j = furnace.gaugeFuelScaled(12);
		if (j > 0) {
			func_73729_b(k + 57, l + 36 + 12 - j, 176, 12 - j, 14, j + 2);
		}
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		final String name = I18n.func_135052_a("tile.techreborn.iron_furnace.name");
		field_146289_q.func_78276_b(name, xSize / 2 - field_146289_q.func_78256_a(name) / 2, 6, 4210752);
		field_146289_q.func_78276_b(I18n.func_135052_a("container.inventory", new Object[0]), 8, ySize - 96 + 2, 4210752);

		super.func_146979_b(mouseX, mouseY);
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		super.func_73863_a(mouseX, mouseY, partialTicks);
		func_191948_b(mouseX, mouseY);
	}

}
