/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import techreborn.items.ItemTechManual;

import java.awt.*;

public class GuiManual extends GuiScreen {

	ItemTechManual manual;
	EntityPlayer player;

	private static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/manual.png");
	int guiWidth = 207;
	int guiHeight = 195;
	private static final String text1 = I18n.func_135052_a("techreborn.manual.wiki");
	private static final String text2 = I18n.func_135052_a("techreborn.manual.discord");


	public GuiManual(EntityPlayer player) {
		this.player = player;
	}

	@Override
	public boolean func_73868_f() {
		return false;
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.add(new GuiButton(1, (field_146294_l / 2 - 30), (field_146295_m / 2 - (guiHeight / 4)) + 17, 60, 20, I18n.func_135052_a("techreborn.manual.wikibtn")));
		field_146292_n.add(new GuiButton(2, (field_146294_l / 2 - 30), (field_146295_m / 2) + 22, 60, 20, I18n.func_135052_a("techreborn.manual.discordbtn")));
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		func_146276_q_();
		field_146297_k.func_110434_K().func_110577_a(GuiManual.texture);
		int centerX = (field_146294_l / 2) - guiWidth / 2;
		int centerY = (field_146295_m / 2) - guiHeight / 2;
		func_73729_b(centerX, centerY, 0, 0, guiWidth, guiHeight);
		field_146289_q.func_78276_b(text1, ((field_146294_l / 2) - field_146289_q.func_78256_a(text1) / 2), field_146295_m / 2 - (guiHeight / 4), 4210752);
		field_146289_q.func_78276_b(text2, ((field_146294_l / 2) - field_146289_q.func_78256_a(text2) / 2), field_146295_m / 2 + 5, 4210752);
		super.func_73863_a(mouseX, mouseY, partialTicks);
	}

	@Override
	protected void func_146284_a(GuiButton button) {
		switch (button.field_146127_k) {
			case 1:
				field_146297_k.func_147108_a(new GuiConfirmOpenLink(this, "http://wiki.techreborn.ovh", 1, false));
				break;
			case 2:
				field_146297_k.func_147108_a(new GuiConfirmOpenLink(this, "http://discord.gg/0tCDWb77cvetwm0e", 2, false));
				break;
		}
	}

	@Override
	public void func_73878_a(boolean result, int id) {
		switch(id) {
			case 1:
				if(result == true) {
					try {
						Desktop.getDesktop().browse(new java.net.URI("http://wiki.techreborn.ovh"));
					} catch (Exception e) {
						System.err.print(e);
					}
				}else {
					field_146297_k.func_147108_a(this);
				}
				break;
			case 2:
				if(result == true) {
					try {
						Desktop.getDesktop().browse(new java.net.URI("http://discord.gg/0tCDWb77cvetwm0e"));
					} catch (Exception e) {
						System.err.print(e);
					}
				}else {
					field_146297_k.func_147108_a(this);
				}
				break;
		}
		}
	}


