/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.entities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.explosion.RebornExplosion;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.lib.ModInfo;

/**
 * Created by Mark on 13/03/2016.
 */
@RebornRegistry(modID = ModInfo.MOD_ID)
public class EntityNukePrimed extends EntityTNTPrimed {

	@ConfigRegistry(config = "misc", category = "nuke", key = "fusetime", comment = "Nuke fuse time (ticks)")
	public static int fuseTime = 400;

	@ConfigRegistry(config = "misc", category = "nuke", key = "radius", comment = "Nuke explision radius")
	public static int radius = 40;

	@ConfigRegistry(config = "misc", category = "nuke", key = "enabled", comment = "Should the nuke explode, set to false to prevent block damage")
	public static boolean enabled = true;

	public EntityNukePrimed(World world) {
		super(world);
		func_184534_a(EntityNukePrimed.fuseTime);
	}

	public EntityNukePrimed(World world, double x, double y, double z, EntityLivingBase tntPlacedBy) {
		super(world, x, y, z, tntPlacedBy);
		func_184534_a(EntityNukePrimed.fuseTime);
	}

	@Override
	public void func_70071_h_() {
		this.field_70169_q = this.field_70165_t;
		this.field_70167_r = this.field_70163_u;
		this.field_70166_s = this.field_70161_v;

		if (!this.func_189652_ae()) {
			this.field_70181_x -= 0.03999999910593033D;
		}

		this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
		this.field_70159_w *= 0.9800000190734863D;
		this.field_70181_x *= 0.9800000190734863D;
		this.field_70179_y *= 0.9800000190734863D;

		if (this.field_70122_E) {
			this.field_70159_w *= 0.699999988079071D;
			this.field_70179_y *= 0.699999988079071D;
			this.field_70181_x *= -0.5D;
		}

		func_184534_a(func_184536_l() - 1);

		if (func_184536_l() <= 0) {
			this.func_70106_y();
			if (!this.field_70170_p.field_72995_K) {
				explodeNuke();
			}
		} else {
			this.func_70072_I();
			this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5D, this.field_70161_v, 0.0D, 0.0D, 0.0D);
		}
	}

	public void explodeNuke() {
		if (!enabled) {
			return;
		}
		RebornExplosion nukeExplosion = new RebornExplosion(new BlockPos(field_70165_t, field_70163_u, field_70161_v), field_70170_p, radius);
		nukeExplosion.setLivingBase(func_94083_c());
		nukeExplosion.explode();
	}
}
