/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.init.recipes;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.recipe.machines.ExtractorRecipe;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;

import techreborn.init.recipes.RecipeMethods.Type;

/**
 * Created by Prospector
 */
public class ExtractorRecipes extends RecipeMethods {
	public static void init() {
		register(getStack(ModBlocks.RUBBER_SAPLING), getMaterial("rubber", Type.PART), false);
		register(getStack(ModBlocks.RUBBER_LOG),  getMaterial("rubber", Type.PART), false);
		register(getStack(Items.field_151123_aH), getMaterial("rubber", 2, Type.PART));
		register(getMaterial("sap", Type.PART), getMaterial("rubber", 3, Type.PART));
		register(getStack(Blocks.field_150328_O), getStack(Items.field_151100_aR, 2, 1), false);
		register(getStack(Blocks.field_150327_N), getStack(Items.field_151100_aR, 2, 11), false);
		register(getStack(Blocks.field_150328_O, 1, 1), getStack(Items.field_151100_aR, 2, 12), false);
		register(getStack(Blocks.field_150328_O, 1, 2), getStack(Items.field_151100_aR, 2, 13), false);
		register(getStack(Blocks.field_150328_O, 1, 3), getStack(Items.field_151100_aR, 2, 7), false);
		register(getStack(Blocks.field_150328_O, 1, 4), getStack(Items.field_151100_aR, 2, 1), false);
		register(getStack(Blocks.field_150328_O, 1, 5), getStack(Items.field_151100_aR, 2, 14), false);
		register(getStack(Blocks.field_150328_O, 1, 6), getStack(Items.field_151100_aR, 2, 7), false);
		register(getStack(Blocks.field_150328_O, 1, 7), getStack(Items.field_151100_aR, 2, 9), false);
		register(getStack(Blocks.field_150328_O, 1, 8), getStack(Items.field_151100_aR, 2, 7), false);
		register(getStack(Blocks.field_150398_cm), getStack(Items.field_151100_aR, 4, 11), false);
		register(getStack(Blocks.field_150398_cm, 1, 1), getStack(Items.field_151100_aR, 4, 13), false);
		register(getStack(Blocks.field_150398_cm, 1, 4), getStack(Items.field_151100_aR, 4, 1), false);
		register(getStack(Blocks.field_150398_cm, 1, 5), getStack(Items.field_151100_aR, 4, 9), false);
		register(getStack(Blocks.field_150329_H, 1, 1), getStack(Items.field_151014_N), false);
		register(getStack(Blocks.field_150329_H, 1, 2), getStack(Items.field_151014_N), false);
		register(getStack(Blocks.field_150398_cm, 1, 2), getStack(Items.field_151014_N, 2), false);
		register(getStack(Blocks.field_150398_cm, 1, 3), getStack(Items.field_151014_N, 2), false);
		register(getStack(Blocks.field_150330_I, 1, 0), getStack(Items.field_151055_y));
		for (int i = 1; i < 15; i++)
			register(getStack(Blocks.field_150325_L, 1, i), getStack(Blocks.field_150325_L, 1, 0), false);
		for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
			register(DynamicCell.getCellWithFluid(fluid), DynamicCell.getEmptyCell(1), false);
		}
	}

	static void register(ItemStack input, ItemStack output) {
		register(input,  output, true);
	}

	static void register(ItemStack input, ItemStack output, boolean oreDict) {
		RecipeHandler.addRecipe(new ExtractorRecipe(input, output, 400, 2, oreDict));
	}
}
