/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items;

import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.util.ChatUtils;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;

import javax.annotation.Nullable;
import java.util.List;

public class ItemFrequencyTransmitter extends ItemTR {

	public ItemFrequencyTransmitter() {
		func_77655_b("techreborn.frequencyTransmitter");
		func_77625_d(1);
		this.func_185043_a(new ResourceLocation("techreborn:coords"), new IItemPropertyGetter() {
			@Override
			@SideOnly(Side.CLIENT)
			public float func_185085_a(ItemStack stack,
			                   @Nullable
				                   World worldIn,
			                   @Nullable
				                   EntityLivingBase entityIn) {
				if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
					return 1.0F;
				}
				return 0.0F;
			}
		});
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos,
	                                  EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		ItemStack stack = player.func_184586_b(hand);
		stack.func_77982_d(new NBTTagCompound());
		stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
		stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
		stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
		stack.func_77978_p().func_74768_a("dim", world.field_73011_w.getDimension());

		if (!world.field_72995_K) {
			ChatUtils.sendNoSpamMessages(MessageIDs.freqTransmitterID, new TextComponentString(
				TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.setTo") + " X: " +
					TextFormatting.GOLD + pos.func_177958_n() +
					TextFormatting.GRAY + " Y: " +
					TextFormatting.GOLD + pos.func_177956_o() +
					TextFormatting.GRAY + " Z: " +
					TextFormatting.GOLD + pos.func_177952_p() +
					TextFormatting.GRAY + " " + I18n.func_135052_a("techreborn.message.in") + " " +
					TextFormatting.GOLD + DimensionManager.getProviderType(world.field_73011_w.getDimension())
					.func_186065_b() + " (" + world.field_73011_w.getDimension() + ")"));
		}
		return EnumActionResult.SUCCESS;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player,
	                                                EnumHand hand) {
		ItemStack stack = player.func_184586_b(hand);
		if (player.func_70093_af()) {
			stack.func_77982_d(null);
			if (!world.field_72995_K) {
				ChatUtils.sendNoSpamMessages(MessageIDs.freqTransmitterID, new TextComponentString(
					TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.coordsHaveBeen") + " "
						+ TextFormatting.GOLD + I18n.func_135052_a("techreborn.message.cleared")));
			}
		}

		return new ActionResult<>(EnumActionResult.SUCCESS, stack);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
			int x = stack.func_77978_p().func_74762_e("x");
			int y = stack.func_77978_p().func_74762_e("y");
			int z = stack.func_77978_p().func_74762_e("z");
			int dim = stack.func_77978_p().func_74762_e("dim");

			tooltip.add(TextFormatting.GRAY + "X: " + TextFormatting.GOLD + x);
			tooltip.add(TextFormatting.GRAY + "Y: " + TextFormatting.GOLD + y);
			tooltip.add(TextFormatting.GRAY + "Z: " + TextFormatting.GOLD + z);
			tooltip.add(TextFormatting.DARK_GRAY + DimensionManager.getProviderType(dim).func_186065_b());

		} else {
			tooltip.add(TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.noCoordsSet"));
		}
	}

	public static class StackInfoFreqTransmitter extends StackInfoElement {
		public StackInfoFreqTransmitter() {
			super(ModItems.FREQUENCY_TRANSMITTER);
		}

		@Override
		public String getText(ItemStack stack) {
			String text = "";
			TextFormatting gold = TextFormatting.GOLD;
			TextFormatting grey = TextFormatting.GRAY;
			if (stack.func_77973_b() instanceof ItemFrequencyTransmitter) {
				if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
					int coordX = stack.func_77978_p().func_74762_e("x");
					int coordY = stack.func_77978_p().func_74762_e("y");
					int coordZ = stack.func_77978_p().func_74762_e("z");
					int coordDim = stack.func_77978_p().func_74762_e("dim");
					text = grey + "X: " + gold + coordX + grey + " Y: " + gold + coordY + grey + " Z: " + gold + coordZ + grey + " Dim: " + gold + DimensionManager.getProviderType(coordDim).func_186065_b() + " (" + coordDim + ")";
				} else {
					text = grey + I18n.func_135052_a("techreborn.message.noCoordsSet");
				}
			}
			return text;
		}
	}
}
