/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.item.Item.ToolMaterial;

public class ItemNanosaber extends ItemSword implements IEnergyItemInfo {
	public static final int maxCharge = ConfigTechReborn.nanoSaberCharge;
	public int cost = 250;

	public ItemNanosaber() {
		super(ToolMaterial.DIAMOND);
		setNoRepair();
		func_77637_a(TechRebornCreativeTab.instance);
		func_77625_d(1);
		func_77655_b("techreborn.nanosaber");
		this.func_185043_a(new ResourceLocation("techreborn:active"), new IItemPropertyGetter() {
			@Override
			@SideOnly(Side.CLIENT)
			public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
				if (ItemUtils.isActive(stack)) {
					ForgePowerItemManager capEnergy = (ForgePowerItemManager) new ForgePowerItemManager(stack);
					if (capEnergy.getMaxEnergyStored() - capEnergy.getEnergyStored() >= 0.9	* capEnergy.getMaxEnergyStored()) {
						return 0.5F;
					}
					return 1.0F;
				}
				return 0.0F;
			}
		});
	}
	
	// ItemSword
	@Override
	public boolean func_77644_a(ItemStack stack, EntityLivingBase entityHit, EntityLivingBase entityHitter) {
		ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
		if (capEnergy.getEnergyStored() >= cost) {
			capEnergy.extractEnergy(cost, false);
			ExternalPowerSystems.requestEnergyFromArmor(capEnergy, entityHitter);

			return true;
		} else {
			return false;
		}
	}	
	
	// Item
	@Override
	public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
		Multimap<String, AttributeModifier> multimap = HashMultimap.<String, AttributeModifier>create();
		int modifier = 0;
		if (ItemUtils.isActive(stack)) {
			modifier = 9;
		}
		if (slot == EntityEquipmentSlot.MAINHAND) {
			multimap.put(SharedMonsterAttributes.field_111264_e.func_111108_a(),
					new AttributeModifier(field_111210_e, "Weapon modifier", (double) modifier, 0));
			multimap.put(SharedMonsterAttributes.field_188790_f.func_111108_a(),
					new AttributeModifier(field_185050_h, "Weapon modifier", -2.4000000953674316D, 0));
		}
		return multimap;
	}
	
	@Override
	public ActionResult<ItemStack> func_77659_a(final World world, final EntityPlayer player, final EnumHand hand) {
		final ItemStack stack = player.func_184586_b(hand);
		if (player.func_70093_af()) {
			if (new ForgePowerItemManager(stack).getEnergyStored() < cost) {
				ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
					TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.nanosaberEnergyErrorTo") + " "
						+ TextFormatting.GOLD + I18n
						.func_135052_a("techreborn.message.nanosaberActivate")));
			} else {
				if (!ItemUtils.isActive(stack)) {
					if (stack.func_77978_p() == null) {
						stack.func_77982_d(new NBTTagCompound());
					}
					stack.func_77978_p().func_74757_a("isActive", true);
					if (world.field_72995_K) {
						ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
							TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.setTo") + " "
								+ TextFormatting.GOLD + I18n
								.func_135052_a("techreborn.message.nanosaberActive")));
					}
				} else {
					stack.func_77978_p().func_74757_a("isActive", false);
					if (world.field_72995_K) {
						ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
							TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.setTo") + " "
								+ TextFormatting.GOLD + I18n
								.func_135052_a("techreborn.message.nanosaberInactive")));
					}
				}
			}
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		}
		return new ActionResult<>(EnumActionResult.PASS, stack);
	}

	@Override
	public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
		if (ItemUtils.isActive(stack) && new ForgePowerItemManager(stack).getEnergyStored() < cost) {
			if(worldIn.field_72995_K){
				ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
					TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.nanosaberEnergyError") + " "
						+ TextFormatting.GOLD + I18n
						.func_135052_a("techreborn.message.nanosaberDeactivating")));
			}
			stack.func_77978_p().func_74757_a("isActive", false);
		}
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		return 1 - ItemUtils.getPowerForDurabilityBar(stack);
	}

	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		return true;
	}

	@Override
	public int getRGBDurabilityForDisplay(ItemStack stack) {
		return PowerSystem.getDisplayPower().colour;
	}

	@Override
	@Nullable
	public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
		return new PoweredItemContainerProvider(stack);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_150895_a(
		CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
		if (!func_194125_a(par2CreativeTabs)) {
			return;
		}
		ItemStack inactiveUncharged = new ItemStack(ModItems.NANOSABER);
		inactiveUncharged.func_77982_d(new NBTTagCompound());
		inactiveUncharged.func_77978_p().func_74757_a("isActive", false);

		ItemStack inactiveCharged = new ItemStack(ModItems.NANOSABER);
		inactiveCharged.func_77982_d(new NBTTagCompound());
		inactiveCharged.func_77978_p().func_74757_a("isActive", false);
		ForgePowerItemManager capEnergy = new ForgePowerItemManager(inactiveCharged);
		capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());

		ItemStack activeCharged = new ItemStack(ModItems.NANOSABER);
		activeCharged.func_77982_d(new NBTTagCompound());
		activeCharged.func_77978_p().func_74757_a("isActive", true);
		ForgePowerItemManager capEnergy2 = new ForgePowerItemManager(activeCharged);
		capEnergy2.setEnergyStored(capEnergy2.getMaxEnergyStored());

		itemList.add(inactiveUncharged);
		itemList.add(inactiveCharged);
		itemList.add(activeCharged);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		if (!ItemUtils.isActive(stack)) {
			tooltip.add(TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.nanosaberInactive"));
		} else {
			tooltip.add(TextFormatting.GRAY + I18n.func_135052_a("techreborn.message.nanosaberActive"));
		}
	}

	// IEnergyItemInfo
	@Override
	public double getMaxPower(ItemStack stack) {
		return maxCharge;
	}

	@Override
	public boolean canAcceptEnergy(ItemStack stack) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(ItemStack stack) {
		return false;
	}

	@Override
	public double getMaxTransfer(ItemStack stack) {
		return 1000;
	}
}
