/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.text.TextFormatting;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.blocks.generator.solarpanel.BlockSolarPanel;
import techreborn.blocks.generator.solarpanel.EnumPanelType;
import techreborn.init.ModBlocks;

import java.util.List;

public class TileSolarPanel extends TilePowerAcceptor implements IToolDrop {

	boolean canSeeSky = false;
	boolean lastSate = false;
	int powerToAdd;
	EnumPanelType panel;

	//This is left here to allow the world to create a new instance of it when loading, do not remove this.
	public TileSolarPanel() {
		super();
	}

	public TileSolarPanel(EnumPanelType panel) {
		this.panel = panel;
	}

	@Override
	public void func_73660_a() {
		super.func_73660_a();
		if (field_145850_b.field_72995_K) {
			return;
		}
		if (field_145850_b.func_82737_E() % 20 == 0) {
			canSeeSky = field_145850_b.func_175710_j(field_174879_c.func_177984_a());
			if(lastSate != isSunOut()){
				field_145850_b.func_175656_a(field_174879_c,
					field_145850_b.func_180495_p(field_174879_c).func_177226_a(BlockSolarPanel.ACTIVE, isSunOut()));
				lastSate = isSunOut();
			}

		}
		if (isSunOut()) {
			powerToAdd = panel.generationRateD;
		} else if (canSeeSky) {
			powerToAdd = panel.generationRateN;
		} else {
			powerToAdd = 0;
		}

		addEnergy(powerToAdd);
	}

	public boolean isSunOut() {
		return canSeeSky && !field_145850_b.func_72896_J() && !field_145850_b.func_72911_I() && field_145850_b.func_72935_r();
	}

	@Override
	public double getBaseMaxPower() {
		return panel.internalCapacity;
	}

	@Override
	public boolean canAcceptEnergy(final EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(final EnumFacing direction) {
		return true;
	}

	@Override
	public double getBaseMaxOutput() {
		return panel.generationRateD;
	}

	@Override
	public double getBaseMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return panel.powerTier;
	}

	@Override
	public EnumPowerTier getBaseTier() {
		return getTier();
	}

	@Override
	public ItemStack getToolDrop(final EntityPlayer playerIn) {
		return new ItemStack(ModBlocks.SOLAR_PANEL, 1, panel.ordinal());
	}
	
	@Override
	public void func_189667_a(Rotation rotationIn) {
		return;
	}

	@Override
	public void func_145839_a(NBTTagCompound tag) {
		if(tag.func_74764_b("panelType")){
			panel = EnumPanelType.values()[tag.func_74762_e("panelType")];
		} else {
			Core.logHelper.warn("A solar panel has failed to load from NBT, it will not work correctly. Please break and replace it to fix the issue. BlockPos:" + field_174879_c.toString());
			panel = EnumPanelType.Basic;
		}
		super.func_145839_a(tag);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tag) {
		tag.func_74768_a("panelType", panel.ordinal());
		return super.func_189515_b(tag);
	}

	@Override
	public void checkTeir() {
		//Nope
	}

	@Override
	public void addInfo(List<String> info, boolean isRealTile) {
		info.add(TextFormatting.GRAY + "Internal Energy Storage: " + TextFormatting.GOLD
			+ PowerSystem.getLocaliszedPowerFormatted((int) getMaxPower()));

		info.add(TextFormatting.GRAY + "Generation Rate Day: " + TextFormatting.GOLD
				+ PowerSystem.getLocaliszedPowerFormatted(panel.generationRateD));

		info.add(TextFormatting.GRAY + "Generation Rate Night: " + TextFormatting.GOLD
			+ PowerSystem.getLocaliszedPowerFormatted(panel.generationRateN));

		info.add(TextFormatting.GRAY + "Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase(getTier().toString()));
	}
}
