/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.tiles.idsu;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.WorldSavedData;
import techreborn.lib.ModInfo;

/**
 * Created by modmuss50 on 13/06/2017.
 */
public class IDSUSaveManger extends WorldSavedData implements IDataIDSU {
	public IDSUSaveManger(String name) {
		super(ModInfo.MOD_ID + "_IDSU");
	}

	@Override
	public void func_76184_a(NBTTagCompound nbt) {
		power = nbt.func_74769_h("power");
	}

	@Override
	public NBTTagCompound func_189551_b(NBTTagCompound compound) {
		compound.func_74780_a("power", power);
		return compound;
	}

	@Override
	public boolean func_76188_b() {
		return true;
	}

	double power;

	@Override
	public double getStoredPower() {
		return power;
	}

	@Override
	public void setStoredPower(double storedPower) {
		power = storedPower;
	}
}
