/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.tiles.lesu;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.IToolDrop;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.init.ModBlocks;

public class TileLSUStorage extends TileLegacyMachineBase 
	implements IToolDrop {

	public LesuNetwork network;

	public final void findAndJoinNetwork(World world, int x, int y, int z) {
		network = new LesuNetwork();
		network.addElement(this);
		for (EnumFacing direction : EnumFacing.values()) {
			if (world.func_175625_s(new BlockPos(x + direction.func_82601_c(), y + direction.func_96559_d(),
					z + direction.func_82599_e())) instanceof TileLSUStorage) {
				TileLSUStorage lesu = (TileLSUStorage) world.func_175625_s(new BlockPos(x + direction.func_82601_c(),
						y + direction.func_96559_d(), z + direction.func_82599_e()));
				if (lesu.network != null) {
					lesu.network.merge(network);
				}
			}
		}
	}

	public final void setNetwork(LesuNetwork n) {
		if (n == null) {
		} else {
			network = n;
			network.addElement(this);
		}
	}

	public final void resetNetwork() {
		network = null;
	}

	public final void removeFromNetwork() {
		if (network == null) {
		} else
			network.removeElement(this);
	}

	public final void rebuildNetwork() {
		removeFromNetwork();
		resetNetwork();
		findAndJoinNetwork(field_145850_b, field_174879_c.func_177958_n(), field_174879_c.func_177956_o(), field_174879_c.func_177952_p());
	}

	// TileLegacyMachineBase
	@Override
	public void func_73660_a() {
		super.func_73660_a();
		if (network == null) {
			findAndJoinNetwork(field_145850_b, field_174879_c.func_177958_n(), field_174879_c.func_177956_o(), field_174879_c.func_177952_p());
		} else {
			if (network.master != null
					&& network.master.func_145831_w().func_175625_s(new BlockPos(network.master.func_174877_v().func_177958_n(),
							network.master.func_174877_v().func_177956_o(), network.master.func_174877_v().func_177952_p())) != network.master) {
				network.master = null;
			}
		}
	}

	// IToolDrop
	@Override
	public ItemStack getToolDrop(EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.LSU_STORAGE, 1);
	}
}
