/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.tiles.tier0;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;

public class TileIronFurnace extends TileLegacyMachineBase
		implements IInventoryProvider, IContainerProvider {

	public int tickTime;
	public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, this);
	public int fuel;
	public int fuelGague;
	public int progress;
	public int fuelScale = 160;
	int input1 = 0;
	int output = 1;
	int fuelslot = 2;
	boolean active = false;

	public int gaugeProgressScaled(final int scale) {
		return this.progress * scale / this.fuelScale;
	}

	public int gaugeFuelScaled(final int scale) {
		if (this.fuelGague == 0) {
			this.fuelGague = this.fuel;
			if (this.fuelGague == 0) {
				this.fuelGague = this.fuelScale;
			}
		}
		return this.fuel * scale / this.fuelGague;
	}

	@Override
	public void func_73660_a() {
		super.func_73660_a();
		if(field_145850_b.field_72995_K){
			return;
		}
		final boolean burning = this.isBurning();
		boolean updateInventory = false;
		if (this.fuel > 0) {
			this.fuel--;
			this.updateState();
		}
		if (this.fuel <= 0 && this.canSmelt()) {
			this.fuel = this.fuelGague = (int) (TileEntityFurnace.func_145952_a(this.func_70301_a(this.fuelslot)) * 1.25);
			if (this.fuel > 0) {
				// Fuel slot
				ItemStack fuelStack = this.func_70301_a(this.fuelslot);
				if (fuelStack.func_77973_b().hasContainerItem(fuelStack)) {
					this.func_70299_a(this.fuelslot, new ItemStack(fuelStack.func_77973_b().func_77668_q()));
				} else if (fuelStack.func_190916_E() > 1) {
					this.func_70298_a(this.fuelslot, 1);
				} else if (fuelStack.func_190916_E() == 1) {
					this.func_70299_a(this.fuelslot, ItemStack.field_190927_a);
				}
				updateInventory = true;
			}
		}
		if (this.isBurning() && this.canSmelt()) {
			this.progress++;
			if (this.progress >= this.fuelScale) {
				this.progress = 0;
				this.cookItems();
				updateInventory = true;
			}
		} else {
			this.progress = 0;
		}
		if (burning != this.isBurning()) {
			updateInventory = true;
		}
		if (updateInventory) {
			this.func_70296_d();
		}
	}

	public void cookItems() {
		if (this.canSmelt()) {
			final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));

			if (this.func_70301_a(this.output).func_190926_b()) {
				this.func_70299_a(this.output, itemstack.func_77946_l());
			} else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
				this.func_70301_a(this.output).func_190917_f(itemstack.func_190916_E());
			}
			if (this.func_70301_a(this.input1).func_190916_E() > 1) {
				this.func_70298_a(this.input1, 1);
			} else {
				this.func_70299_a(this.input1, ItemStack.field_190927_a);
			}
		}
	}

	public boolean canSmelt() {
		if (this.func_70301_a(this.input1).func_190926_b())
			return false;
		final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
		if (itemstack.func_190926_b())
			return false;
		if (this.func_70301_a(this.output).func_190926_b())
			return true;
		if (!this.func_70301_a(this.output).func_77969_a(itemstack))
			return false;
		final int result = this.func_70301_a(this.output).func_190916_E() + itemstack.func_190916_E();
		return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
	}

	public boolean isBurning() {
		return this.fuel > 0;
	}

	public ItemStack getResultFor(final ItemStack stack) {
		final ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
		if (!result.func_190926_b()) {
			return result.func_77946_l();
		}
		return ItemStack.field_190927_a;
	}

	public void updateState() {
		final IBlockState BlockStateContainer = this.field_145850_b.func_180495_p(this.field_174879_c);
		if (BlockStateContainer.func_177230_c() instanceof BlockMachineBase) {
			final BlockMachineBase blockMachineBase = (BlockMachineBase) BlockStateContainer.func_177230_c();
			if (BlockStateContainer.func_177229_b(BlockMachineBase.ACTIVE) != this.fuel > 0)
				blockMachineBase.setActive(this.fuel > 0, this.field_145850_b, this.field_174879_c);
		}
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	@Override
	public boolean func_94041_b(int index, ItemStack stack) {
		boolean isFuel = TileEntityFurnace.func_145954_b(stack);
		if(isFuel){
			ItemStack fuelSlotStack = func_70301_a(fuelslot);
			if(fuelSlotStack.func_190926_b() || ItemUtils.isItemEqual(stack, fuelSlotStack, true, true) && fuelSlotStack.func_77976_d() != fuelSlotStack.func_190916_E()){
				return index == fuelslot;
			}
		}
		return index != output;
	}
	
	@Override
	public boolean canBeUpgraded() {
		return false;
	}

	public int getBurnTime() {
		return this.fuel;
	}

	public void setBurnTime(final int burnTime) {
		this.fuel = burnTime;
	}

	public int getTotalBurnTime() {
		return this.fuelGague;
	}

	public void setTotalBurnTime(final int totalBurnTime) {
		this.fuelGague = totalBurnTime;
	}

	public int getProgress() {
		return progress;
	}

	public void setProgress(int progress) {
		this.progress = progress;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("ironfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this).fuelSlot(2, 56, 53).slot(0, 56, 17).outputSlot(1, 116, 35)
				.syncIntegerValue(this::getBurnTime, this::setBurnTime)
				.syncIntegerValue(this::getProgress, this::setProgress)
				.syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create(this);
	}
}
