/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2018 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.tiles.tier1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.WorldUtils;
import techreborn.init.ModBlocks;
import techreborn.lib.ModInfo;

import java.util.Iterator;

@RebornRegistry(modID = ModInfo.MOD_ID)
public class TilePlayerDectector extends TilePowerAcceptor implements IToolDrop {

	@ConfigRegistry(config = "machines", category = "player_detector", key = "PlayerDetectorMaxInput", comment = "Player Detector Max Input (Value in EU)")
	public static int maxInput = 32;
	@ConfigRegistry(config = "machines", category = "player_detector", key = "PlayerDetectorMaxEnergy", comment = "Player Detector Max Energy (Value in EU)")
	public static int maxEnergy = 10000;
	@ConfigRegistry(config = "machines", category = "player_detector", key = "PlayerDetectorEUPerSecond", comment = "Player Detector Energy Consumption per second (Value in EU)")
	public static int euPerTick = 10;

	public String owenerUdid = "";
	boolean redstone = false;

	public TilePlayerDectector() {
		super();
	}
	
	public boolean isProvidingPower() {
		return redstone;
	}

	// TilePowerAcceptor
	@Override
	public void func_73660_a() {
		super.func_73660_a();
		if (!field_145850_b.field_72995_K && field_145850_b.func_72820_D() % 20 == 0) {
			boolean lastRedstone = redstone;
			redstone = false;
			if (canUseEnergy(euPerTick)) {
				Iterator<EntityPlayer> tIterator = super.field_145850_b.field_73010_i.iterator();
				while (tIterator.hasNext()) {
					EntityPlayer player = (EntityPlayer) tIterator.next();
					if (player.func_70092_e((double) super.func_174877_v().func_177958_n() + 0.5D,
						(double) super.func_174877_v().func_177956_o() + 0.5D, (double) super.func_174877_v().func_177952_p() + 0.5D) <= 256.0D) {
						BlockMachineBase blockMachineBase = (BlockMachineBase) field_145850_b.func_180495_p(field_174879_c).func_177230_c();
						int meta = blockMachineBase.func_176201_c(field_145850_b.func_180495_p(field_174879_c));
						if (meta == 0) {// ALL
							redstone = true;
						} else if (meta == 1) {// Others
							if (!owenerUdid.isEmpty() && !owenerUdid.equals(player.func_110124_au().toString())) {
								redstone = true;
							}
						} else {// You
							if (!owenerUdid.isEmpty() && owenerUdid.equals(player.func_110124_au().toString())) {
								redstone = true;
							}
						}
					}
				}
				useEnergy(euPerTick);
			}
			if (lastRedstone != redstone) {
				WorldUtils.updateBlock(field_145850_b, field_174879_c);
				field_145850_b.func_175685_c(field_174879_c, field_145850_b.func_180495_p(field_174879_c).func_177230_c(), true);
			}
		}
	}
	
	@Override
	public double getBaseMaxPower() {
		return maxEnergy;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public double getBaseMaxOutput() {
		return 0;
	}

	@Override
	public double getBaseMaxInput() {
		return maxInput;
	}

	@Override
	public void func_145839_a(NBTTagCompound tag) {
		super.func_145839_a(tag);
		owenerUdid = tag.func_74779_i("ownerID");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tag) {
		super.func_189515_b(tag);
		tag.func_74778_a("ownerID", owenerUdid);
		return tag;
	}

	// IToolDrop
	@Override
	public ItemStack getToolDrop(EntityPlayer p0) {
		return new ItemStack(ModBlocks.PLAYER_DETECTOR, 1, 0);
	}
}
