/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ingredients.ItemParts;

@RebornRegistry(modID="techreborn")
public class TileMatterFabricator
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="matter_fabricator", key="MatterFabricatorMaxInput", comment="Matter Fabricator Max Input (Value in EU)")
    public static int maxInput = 8192;
    @ConfigRegistry(config="machines", category="matter_fabricator", key="MatterFabricatorMaxEnergy", comment="Matter Fabricator Max Energy (Value in EU)")
    public static int maxEnergy = 10000000;
    @ConfigRegistry(config="machines", category="matter_fabricator", key="MatterFabricatorFabricationRate", comment="Matter Fabricator Fabrication Rate, amount of amplifier units per UUM")
    public static int fabricationRate = 6000;
    @ConfigRegistry(config="machines", category="matter_fabricator", key="MatterFabricatorEnergyPerAmp", comment="Matter Fabricator EU per amplifier unit, multiply this with the rate for total EU")
    public static int energyPerAmp = 5;
    public Inventory inventory = new Inventory(12, "TileMatterFabricator", 64, (TileEntity)this);
    private int amplifier = 0;

    private boolean spaceForOutput() {
        for (int i = 6; i < 11; ++i) {
            if (!this.spaceForOutput(i)) continue;
            return true;
        }
        return false;
    }

    private boolean spaceForOutput(int slot) {
        return this.inventory.func_70301_a(slot).func_190926_b() || ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true) && this.inventory.func_70301_a(slot).func_190916_E() < 64;
    }

    private void addOutputProducts() {
        for (int i = 6; i < 11; ++i) {
            if (!this.spaceForOutput(i)) continue;
            this.addOutputProducts(i);
            break;
        }
    }

    private void addOutputProducts(int slot) {
        if (this.inventory.func_70301_a(slot).func_190926_b()) {
            this.inventory.func_70299_a(slot, new ItemStack(ModItems.UU_MATTER));
        } else if (ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true)) {
            this.inventory.func_70301_a(slot).func_190920_e(Math.min(64, 1 + this.inventory.func_70301_a(slot).func_190916_E()));
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ModItems.PARTS && itemStack.func_77952_i() == ItemParts.getPartByName("scrap").func_77952_i()) {
            return 200;
        }
        if (itemStack.func_77973_b() == ModItems.SCRAP_BOX) {
            return 2000;
        }
        if (IC2Duplicates.SCRAP.hasIC2Stack() && ItemUtils.isInputEqual((Object)itemStack, (ItemStack)IC2Duplicates.SCRAP.getIc2Stack(), (boolean)true, (boolean)true, (boolean)true)) {
            return 200;
        }
        return 0;
    }

    public int getProgress() {
        return this.amplifier;
    }

    public void setProgress(int progress) {
        this.amplifier = progress;
    }

    public int getProgressScaled(int scale) {
        if (this.amplifier != 0) {
            return Math.min(this.amplifier * scale / fabricationRate, 100);
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_73660_a();
        this.charge(11);
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !this.spaceForOutput()) continue;
            int amp = this.getValue(stack);
            int euNeeded = amp * energyPerAmp;
            if (amp == 0 || !this.canUseEnergy(euNeeded)) continue;
            this.useEnergy(euNeeded);
            this.amplifier += amp;
            this.inventory.func_70298_a(i, 1);
        }
        if (this.amplifier >= fabricationRate && this.spaceForOutput()) {
            this.addOutputProducts();
            this.amplifier -= fabricationRate;
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.MATTER_FABRICATOR, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("matterfabricator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 30, 20).slot(1, 50, 20).slot(2, 70, 20).slot(3, 90, 20).slot(4, 110, 20).slot(5, 130, 20).outputSlot(6, 40, 66).outputSlot(7, 60, 66).outputSlot(8, 80, 66).outputSlot(9, 100, 66).outputSlot(10, 120, 66).energySlot(11, 8, 72).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create((TileLegacyMachineBase)this);
    }
}

