/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.storage;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import reborncore.api.power.EnumPowerTier;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;
import techreborn.tiles.storage.TileEnergyStorage;

@RebornRegistry(modID="techreborn")
public class TileAdjustableSU
extends TileEnergyStorage
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="aesu", key="AesuMaxInput", comment="AESU Max Input (Value in EU)")
    public static int maxInput = 8192;
    @ConfigRegistry(config="machines", category="aesu", key="AesuMaxOutput", comment="AESU Max Output (Value in EU)")
    public static int maxOutput = 8192;
    @ConfigRegistry(config="machines", category="aesu", key="AesuMaxEnergy", comment="AESU Max Energy (Value in EU)")
    public static int maxEnergy = 100000000;
    public Inventory inventory = new Inventory(4, "TileAdjustableSU", 64, (TileEntity)this);
    private int OUTPUT = 64;

    public TileAdjustableSU() {
        super("ADJUSTABLE_SU", 4, ModBlocks.ADJUSTABLE_SU, EnumPowerTier.INSANE, maxInput, maxOutput, maxEnergy);
    }

    public void handleGuiInputFromClient(int id) {
        if (id == 300) {
            this.OUTPUT += 256;
        }
        if (id == 301) {
            this.OUTPUT += 64;
        }
        if (id == 302) {
            this.OUTPUT -= 64;
        }
        if (id == 303) {
            this.OUTPUT -= 256;
        }
        if (this.OUTPUT > maxOutput) {
            this.OUTPUT = maxOutput;
        }
        if (this.OUTPUT <= -1) {
            this.OUTPUT = 0;
        }
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.ADJUSTABLE_SU, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public int getCurrentOutput() {
        return this.OUTPUT;
    }

    public void setCurentOutput(int output) {
        this.OUTPUT = output;
    }

    @Override
    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    @Override
    public double getBaseMaxOutput() {
        return this.OUTPUT;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("output", this.OUTPUT);
        this.inventory.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.OUTPUT = nbttagcompound.func_74762_e("output");
        this.inventory.readFromNBT(nbttagcompound);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("aesu").player(player.field_71071_by).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().tile((IInventory)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().syncIntegerValue(this::getCurrentOutput, this::setCurentOutput).addInventory().create((TileLegacyMachineBase)this);
    }
}

