/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import reborncore.api.recipe.RecipeHandler;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;

@RebornRegistry(modID="techreborn")
public class TileAlloySmelter
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="alloy_smelter", key="AlloySmelterMaxInput", comment="Alloy Smelter Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="alloy_smelter", key="AlloySmelterMaxEnergy", comment="Alloy Smelter Max Energy (Value in EU)")
    public static int maxEnergy = 1000;

    public TileAlloySmelter() {
        super("AlloySmelter", maxInput, maxEnergy, ModBlocks.ALLOY_SMELTER, 3);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2};
        this.inventory = new Inventory(4, "TileAlloySmelter", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.ALLOY_SMELTER_RECIPE, (TileEntity)this, 2, 1, this.inventory, inputs, outputs);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloysmelter").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).filterSlot(0, 34, 47, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(0), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).filterSlot(1, 126, 47, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(1), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).outputSlot(2, 80, 47).energySlot(3, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }
}

