/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.StandardValidation;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.util.Arrays;
import java.util.List;

public final class IdentifierValidation {
    private static final List<String> ILLEGAL_IDENTIFIERS = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "_");

    private IdentifierValidation() {
    }

    public static boolean validateClassName(ValidationContext vc, String name, boolean isInner) {
        String[] parts;
        if (!StandardValidation.notBlank(vc, name)) {
            return false;
        }
        if (isInner) {
            return IdentifierValidation.validateIdentifier(vc, name);
        }
        for (String part : parts = name.split("/")) {
            IdentifierValidation.validateIdentifier(vc, part);
        }
        return true;
    }

    public static boolean validateIdentifier(ValidationContext vc, String name) {
        if (!StandardValidation.notBlank(vc, name)) {
            return false;
        }
        if (IdentifierValidation.checkForReservedName(vc, name)) {
            return false;
        }
        int cp = name.codePointAt(0);
        int position = 1;
        if (!Character.isJavaIdentifierStart(cp)) {
            vc.raise(Message.ILLEGAL_IDENTIFIER, name, new String(Character.toChars(cp)), position);
            return false;
        }
        for (int i = Character.charCount(cp); i < name.length(); i += Character.charCount(cp)) {
            cp = name.codePointAt(i);
            ++position;
            if (Character.isJavaIdentifierPart(cp)) continue;
            vc.raise(Message.ILLEGAL_IDENTIFIER, name, new String(Character.toChars(cp)), position);
            return false;
        }
        return true;
    }

    private static boolean checkForReservedName(ValidationContext vc, String name) {
        if (IdentifierValidation.isReservedMethodName(name)) {
            vc.raise(Message.RESERVED_IDENTIFIER, name);
            return true;
        }
        return false;
    }

    public static boolean isReservedMethodName(String name) {
        return ILLEGAL_IDENTIFIERS.contains(name);
    }
}

