/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation;

import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.Objects;

public class Lambda
implements Translatable {
    private final String invokedName;
    private final MethodDescriptor invokedType;
    private final MethodDescriptor samMethodType;
    private final ParentedEntry<?> implMethod;
    private final MethodDescriptor instantiatedMethodType;

    public Lambda(String invokedName, MethodDescriptor invokedType, MethodDescriptor samMethodType, ParentedEntry<?> implMethod, MethodDescriptor instantiatedMethodType) {
        this.invokedName = invokedName;
        this.invokedType = invokedType;
        this.samMethodType = samMethodType;
        this.implMethod = implMethod;
        this.instantiatedMethodType = instantiatedMethodType;
    }

    public TranslateResult<Lambda> extendedTranslate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        MethodEntry samMethod = new MethodEntry(this.getInterface(), this.invokedName, this.samMethodType);
        EntryMapping samMethodMapping = this.resolveMapping(resolver, mappings, samMethod);
        return TranslateResult.of(samMethodMapping == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new Lambda(samMethodMapping != null ? samMethodMapping.getTargetName() : this.invokedName, this.invokedType.extendedTranslate(translator, resolver, mappings).getValue(), this.samMethodType.extendedTranslate(translator, resolver, mappings).getValue(), this.implMethod.extendedTranslate(translator, resolver, mappings).getValue(), this.instantiatedMethodType.extendedTranslate(translator, resolver, mappings).getValue()));
    }

    private EntryMapping resolveMapping(EntryResolver resolver, EntryMap<EntryMapping> mappings, MethodEntry methodEntry) {
        for (MethodEntry entry : resolver.resolveEntry(methodEntry, ResolutionStrategy.RESOLVE_ROOT)) {
            EntryMapping mapping = mappings.get(entry);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    public ClassEntry getInterface() {
        return this.invokedType.getReturnDesc().getTypeEntry();
    }

    public String getInvokedName() {
        return this.invokedName;
    }

    public MethodDescriptor getInvokedType() {
        return this.invokedType;
    }

    public MethodDescriptor getSamMethodType() {
        return this.samMethodType;
    }

    public ParentedEntry<?> getImplMethod() {
        return this.implMethod;
    }

    public MethodDescriptor getInstantiatedMethodType() {
        return this.instantiatedMethodType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lambda lambda = (Lambda)o;
        return Objects.equals(this.invokedName, lambda.invokedName) && Objects.equals(this.invokedType, lambda.invokedType) && Objects.equals(this.samMethodType, lambda.samMethodType) && Objects.equals(this.implMethod, lambda.implMethod) && Objects.equals(this.instantiatedMethodType, lambda.instantiatedMethodType);
    }

    public int hashCode() {
        return Objects.hash(this.invokedName, this.invokedType, this.samMethodType, this.implMethod, this.instantiatedMethodType);
    }

    public String toString() {
        return "Lambda{invokedName='" + this.invokedName + '\'' + ", invokedType=" + this.invokedType + ", samMethodType=" + this.samMethodType + ", implMethod=" + this.implMethod + ", instantiatedMethodType=" + this.instantiatedMethodType + '}';
    }
}

