/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.command.Command;
import cuchaz.enigma.command.MappingCommandsUtil;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingOperations;
import cuchaz.enigma.translation.mapping.serde.MappingFileNameFormat;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.utils.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class InvertMappingsCommand
extends Command {
    public InvertMappingsCommand() {
        super("invert-mappings");
    }

    @Override
    public String getUsage() {
        return "<source-format> <source> <result-format> <result>";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 4;
    }

    @Override
    public void run(String ... args) throws IOException, MappingParseException {
        MappingSaveParameters saveParameters = new MappingSaveParameters(MappingFileNameFormat.BY_DEOBF);
        EntryTree<EntryMapping> source = MappingCommandsUtil.read(args[0], Paths.get(args[1], new String[0]), saveParameters);
        EntryTree result = MappingOperations.invert(source);
        Path output = Paths.get(args[3], new String[0]);
        Utils.delete((Path)output);
        MappingCommandsUtil.write((EntryTree<EntryMapping>)result, args[2], output, saveParameters);
    }
}

