/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassInheritanceTreeNode
extends DefaultMutableTreeNode {
    private final Translator translator;
    private final ClassEntry obfClassEntry;

    public ClassInheritanceTreeNode(Translator translator, String obfClassName) {
        this.translator = translator;
        this.obfClassEntry = new ClassEntry(obfClassName);
    }

    public static ClassInheritanceTreeNode findNode(ClassInheritanceTreeNode node, ClassEntry entry) {
        if (node.getObfClassName().equals(entry.getFullName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassInheritanceTreeNode foundNode = ClassInheritanceTreeNode.findNode((ClassInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public ClassEntry getClassEntry() {
        return this.obfClassEntry;
    }

    public String getObfClassName() {
        return this.obfClassEntry.getFullName();
    }

    @Override
    public String toString() {
        return this.translator.translate(this.obfClassEntry).getFullName();
    }

    public void load(InheritanceIndex ancestries, boolean recurse) {
        ArrayList<ClassInheritanceTreeNode> nodes = Lists.newArrayList();
        for (ClassEntry inheritor : ancestries.getChildren(this.obfClassEntry)) {
            nodes.add(new ClassInheritanceTreeNode(this.translator, inheritor.getFullName()));
        }
        nodes.forEach(this::add);
        if (recurse) {
            for (ClassInheritanceTreeNode node : nodes) {
                node.load(ancestries, true);
            }
        }
    }
}

