/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodImplementationsTreeNode
extends DefaultMutableTreeNode {
    private final Translator translator;
    private MethodEntry entry;

    public MethodImplementationsTreeNode(Translator translator, MethodEntry entry) {
        this.translator = translator;
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.entry = entry;
    }

    public static MethodImplementationsTreeNode findNode(MethodImplementationsTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodImplementationsTreeNode foundNode = MethodImplementationsTreeNode.findNode((MethodImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public MethodEntry getMethodEntry() {
        return this.entry;
    }

    @Override
    public String toString() {
        MethodEntry translatedEntry = this.translator.translate(this.entry);
        return translatedEntry.getFullName() + "()";
    }

    public void load(JarIndex index) {
        ArrayList<MethodImplementationsTreeNode> nodes = Lists.newArrayList();
        EntryIndex entryIndex = index.getEntryIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        Collection<ClassEntry> descendants = inheritanceIndex.getDescendants((ClassEntry)this.entry.getParent());
        for (ClassEntry inheritor : descendants) {
            MethodEntry methodEntry = this.entry.withParent(inheritor);
            if (!entryIndex.hasMethod(methodEntry)) continue;
            nodes.add(new MethodImplementationsTreeNode(this.translator, methodEntry));
        }
        nodes.forEach(this::add);
    }
}

