/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodInheritanceTreeNode
extends DefaultMutableTreeNode {
    private final Translator translator;
    private MethodEntry entry;
    private boolean implemented;

    public MethodInheritanceTreeNode(Translator translator, MethodEntry entry, boolean implemented) {
        this.translator = translator;
        this.entry = entry;
        this.implemented = implemented;
    }

    public static MethodInheritanceTreeNode findNode(MethodInheritanceTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodInheritanceTreeNode foundNode = MethodInheritanceTreeNode.findNode((MethodInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public MethodEntry getMethodEntry() {
        return this.entry;
    }

    public boolean isImplemented() {
        return this.implemented;
    }

    @Override
    public String toString() {
        MethodEntry translatedEntry = this.translator.translate(this.entry);
        if (!this.implemented) {
            return ((ClassEntry)translatedEntry.getParent()).getFullName();
        }
        return translatedEntry.getFullName() + "()";
    }

    public boolean load(JarIndex index) {
        EntryIndex entryIndex = index.getEntryIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        boolean ret = false;
        for (ClassEntry inheritorEntry : inheritanceIndex.getChildren((ClassEntry)this.entry.getParent())) {
            MethodEntry methodEntry = new MethodEntry(inheritorEntry, this.entry.getName(), this.entry.getDesc());
            MethodInheritanceTreeNode node = new MethodInheritanceTreeNode(this.translator, methodEntry, entryIndex.hasMethod(methodEntry));
            boolean childOverride = node.load(index);
            if (!childOverride && !node.implemented) continue;
            this.add(node);
            ret = true;
        }
        return ret;
    }
}

